package net.mehvahdjukaar.moonlight.api.events;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public interface IDropItemOnDeathEvent extends SimpleEvent {

    @ExpectPlatform
    static IDropItemOnDeathEvent create(class_1799 itemStack, class_1657 player, boolean beforeDrop) {
        throw new AssertionError();
    }

    /**
     * If true this is fired before the item is dropped. If false its after the item is cloned
     * Cancel the event on both if you want it to both not drop and persist
     * If you want to modify the returned stack only do it once in one of those
     */
    boolean isBeforeDrop();

    class_1657 getPlayer();

    class_1799 getItemStack();

    /**
     * Prevents item from dropping if before drop is true. From being copied to the new player if after
     */
    void setCanceled(boolean cancelled);

    boolean isCanceled();

    /**
     * Sets the stack to return to the player
     */
    void setReturnItemStack(class_1799 stack);

    class_1799 getReturnItemStack();
}