package net.mehvahdjukaar.moonlight.api.events.fabric;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.core.misc.VillagerBrainEventInternal;
import net.minecraft.class_1646;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4831;
import net.minecraft.class_7893;
import org.jetbrains.annotations.ApiStatus;

import java.util.Map;
import java.util.Optional;

public class VillagerBrainEvent implements IVillagerBrainEvent {

    //hack so we can extend Event class
    private final VillagerBrainEventInternal internal;

    /**
     * used to add activities, memories, sensor types and modify schedules in a compatible way
     * Main feature is easily adding scheduled activities without overriding the whole schedule and adding sensor types
     */
    public VillagerBrainEvent(class_4095<class_1646> brain, class_1646 villager) {
        this.internal = new VillagerBrainEventInternal(brain, villager);
    }

    /**
     * If possible do not access the villager brain directly. The whole porpouse of this is to makde adding activities work better
     * between mods without modifying the brain directly. Use the methods below
     *
     * @return villager entity
     */
    public class_1646 getVillager() {
        return internal.getVillager();
    }

    /**
     * access the brain memories to add new ones or remove existing ones
     * Important: to register a new memory types use the static method in VillagerAIManager otherwise they will not be able to be saved if you add them here manually
     *
     * @return brain memories
     */
    public Map<class_4140<?>, Optional<? extends class_4831<?>>> getMemories() {
        return internal.getMemories();
    }

    /**
     * add an activity to the brain.
     * However this isn't recommended since it doesn't completely clear its previous requirements from the requirements map. This might not be an issue tho
     * Try to use addTaskToActivity instead if you just want to add a task to an existing activity without completely overriding it
     *
     * @param activity        the identifier of the activity
     * @param activityPackage the play package itself that will be executed
     */
    public void addOrReplaceActivity(class_4168 activity, ImmutableList<? extends Pair<Integer, ? extends class_7893<? super class_1646>>> activityPackage) {
        this.internal.addOrReplaceActivity(activity, activityPackage);
    }

    /**
     * Adds an activity to the schedule. will override any activity that is in that specified time window
     * Note that subsequent call to this from other mods in later event execution might override your activity if the time window is the same
     * If it's not it might be shortened or cut in two
     *
     * @param activity  activity to register
     * @param startTime day time at which activity will start
     * @param endTime   day time at which activity will end. can also be less than start time
     */
    public void scheduleActivity(class_4168 activity, int startTime, int endTime) {
        this.internal.scheduleActivity(activity, startTime, endTime);
    }

    //this might be bad

    /**
     * Adds a sensor to the villager
     *
     * @param newSensor sensor to be added
     */
    public void addSensor(class_4149<? extends class_4148<class_1646>> newSensor) {
        this.internal.addSensor(newSensor);
    }


    /**
     * Used to add a single task to an existing activity. Useful so you can add to existing activities without overriding or having to override the entire activity.
     * Alternatively you can define your own activity and add it to the villager schedule using scheduleActivity
     *
     * @param activity activity you want to add a task to
     * @param task     task to add with its priority
     * @return if successfull
     */
    public <P extends Pair<Integer, ? extends class_4097<class_1646>>> boolean addTaskToActivity(class_4168 activity, P task) {
        return this.internal.addTaskToActivity(activity,task);
    }

    @ApiStatus.Internal
    public VillagerBrainEventInternal getInternal() {
        return internal;
    }
}
