package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3417;
import net.minecraft.class_4174;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Consumer;

public class FoodProvider {

    public static final Codec<FoodProvider> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            class_7923.field_41178.method_39673().fieldOf("item").forGetter(f -> f.food),
            StrOpt.of(SoftFluid.Capacity.INT_CODEC, "divider", 1).forGetter(f -> f.divider)
    ).apply(instance, FoodProvider::create));

    public static final FoodProvider EMPTY = new FoodProvider(class_1802.field_8162, 1);

    protected final class_1792 food;
    protected final int divider;

    private FoodProvider(class_1792 food, int divider) {
        this.food = food;
        this.divider = divider;
    }

    public class_1792 getFood() {
        return food;
    }

    public int getDivider() {
        return divider;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    /**
     * Consumes some fluid and gives the player the appropriate effect
     *
     * @return if one unit has been consumed
     */
    public boolean consume(class_1657 player, class_1937 world, @Nullable Consumer<class_1799> nbtApplier) {

        class_1799 stack = this.food.method_7854();
        if (nbtApplier != null) nbtApplier.accept(stack);

        //food

        class_4174 foodProperties = PlatHelper.getFoodProperties(this.food, stack, player);
        //single items are handled by items themselves
        if (this.divider == 1) {
            this.food.method_7861(stack.method_7972(), world, player);
            if (foodProperties == null || stack.method_7909().method_19263()) {
                player.method_5783(this.food.method_21831(), 1, 1);
            }
            //player already plays sound
            return true;
        }
        if (foodProperties != null && player.method_7332(false)) {

            player.method_7344().method_7585(foodProperties.method_19230() / this.divider, foodProperties.method_19231() / (float) this.divider);
            player.method_5783(this.food.method_21831(), 1, 1);
            return true;
        }
        return false;
    }

    public static FoodProvider create(class_1792 item, int divider) {
        return CUSTOM_PROVIDERS.getOrDefault(item, new FoodProvider(item, divider));
    }

    private static final FoodProvider XP = new FoodProvider(class_1802.field_8287, 1) {

        @Override
        public boolean consume(class_1657 player, class_1937 world, @Nullable Consumer<class_1799> nbtApplier) {
            player.method_7255(Utils.getXPinaBottle(1, world.field_9229));
            player.method_5783(class_3417.field_14627, 1, 1);
            return true;
        }
    };

    private static final FoodProvider MILK = new FoodProvider(class_1802.field_8103, 3) {

        @Override
        public boolean consume(class_1657 player, class_1937 world, @Nullable Consumer<class_1799> nbtApplier) {
            class_1799 stack = this.food.method_7854();
            if (nbtApplier != null) nbtApplier.accept(stack);
            for (class_1293 effect : player.method_6088().values()) {
                if (ForgeHelper.isCurativeItem(stack, effect)) {
                    player.method_6016(effect.method_5579());
                    break;
                }
            }
            player.method_5783(this.food.method_21831(), 1, 1);
            return true;
        }
    };

    private static final FoodProvider SUS_STEW = new FoodProvider(class_1802.field_8766, 2) {

        @Override
        public boolean consume(class_1657 player, class_1937 world, @Nullable Consumer<class_1799> nbtApplier) {

            class_1799 stack = this.food.method_7854();
            if (nbtApplier != null) nbtApplier.accept(stack);
            class_4174 foodProperties = this.food.method_19264();
            if (foodProperties != null && player.method_7332(false)) {

                class_2487 tag = stack.method_7969();
                if (tag != null && tag.method_10573("Effects", 9)) {
                    class_2499 effects = tag.method_10554("Effects", 10);
                    for (int i = 0; i < effects.size(); ++i) {
                        int j = 160;
                        class_2487 effectsCompound = effects.method_10602(i);
                        if (effectsCompound.method_10573("EffectDuration", 3))
                            j = effectsCompound.method_10550("EffectDuration") / this.divider;
                        class_1291 effect = class_1291.method_5569(effectsCompound.method_10571("EffectId"));
                        if (effect != null) {
                            player.method_6092(new class_1293(effect, j));
                        }
                    }
                }
                player.method_7344().method_7585(foodProperties.method_19230() / this.divider, foodProperties.method_19231() / (float) this.divider);
                player.method_5783(this.food.method_21831(), 1, 1);
                return true;
            }
            return false;
        }
    };

    public static final Map<class_1792, FoodProvider> CUSTOM_PROVIDERS = Map.of(
            class_1802.field_8162, EMPTY,
            class_1802.field_8766, SUS_STEW,
            class_1802.field_8103, MILK,
            class_1802.field_8287, XP
    );
}
