package net.mehvahdjukaar.moonlight.api.fluids;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.ModFluidRenderProperties;
import net.minecraft.class_1814;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2404;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Supplier;

//I hate this class
public abstract class ModFlowingFluid extends class_3609 {

    @Nullable
    private final Supplier<? extends class_2404> block;
    private final boolean convertsToSource;
    public final boolean hasCustomFluidType;

    protected ModFlowingFluid(Properties properties, Supplier<? extends class_2404> block) {
        this.block = block;
        this.convertsToSource = properties.canConvertToSource;
        this.hasCustomFluidType = properties.copyFluid == null;
        this.afterInit(properties);
    }

    private void afterInit(ModFlowingFluid.Properties properties) {
    }

    public static Properties properties() {
        return new Properties();
    }

    @Override
    protected boolean method_15737(class_1937 level) {
        return convertsToSource;
    }

    @Override
    protected void method_15730(class_1936 worldIn, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = state.method_31709() ? worldIn.method_8321(pos) : null;
        class_2248.method_9610(state, worldIn, pos, blockEntity);
    }

    @Override
    protected boolean method_15777(class_3610 state, class_1922 level, class_2338 pos, class_3611 fluidIn, class_2350 direction) {
        // Based on the water implementation, may need to be overriden for mod fluids that shouldn't behave like water.
        return direction == class_2350.field_11033 && !method_15780(fluidIn);
    }

    @Override
    protected class_2680 method_15790(class_3610 state) {
        if (block != null)
            return block.get().method_9564().method_11657(class_2404.field_11278, method_15741(state));
        return class_2246.field_10124.method_9564();
    }

    @Override
    public boolean method_15780(class_3611 fluidIn) {
        return fluidIn == method_15751() || fluidIn == method_15750();
    }

    @Override
    public abstract class_3611 method_15751();

    @Override
    public abstract class_3611 method_15750();

    @Environment(EnvType.CLIENT)
    public abstract ModFluidRenderProperties createRenderProperties();

    /**
     * This is for normal fluids. Just wraps forge stuff. I'll figure out fabric implementation
     */
    @SuppressWarnings("All") //dont care here as this object wont even be used
    public static final class Properties {
        public String descriptionId;
        public double motionScale = 0.014D;
        public boolean canPushEntity = true;
        public boolean canSwim = true;
        public boolean canDrown = true;
        public float fallDistanceModifier = 0.5F;
        public boolean canExtinguish = false;
        public boolean supportsBoating = false;
        public boolean canConvertToSource = false;
        @Nullable
        public class_7 pathType = class_7.field_18,
                adjacentPathType = class_7.field_4;
        public boolean canHydrate = false;
        public int lightLevel = 0,
                density = 1000,
                temperature = 300,
                viscosity = 1000;
        public class_1814 rarity = class_1814.field_8906;
        public Map<String, class_3414> sounds;
        @Deprecated
        public class_3611 copyFluid = null;

        @Deprecated(forRemoval = true)
        public Properties copyFluid(class_3611 fluid) {
            //this.copyFluid = fluid; //causes issues
            return this;
        }

        /**
         * Sets the identifier representing the name of the fluid type.
         */
        public Properties descriptionId(String descriptionId) {
            this.descriptionId = descriptionId;
            return this;
        }

        /**
         * Sets how much the velocity of the fluid should be scaled by.
         */
        public Properties motionScale(double motionScale) {
            this.motionScale = motionScale;
            return this;
        }

        public Properties setCanConvertToSource(boolean canConvertToSource) {
            this.canConvertToSource = canConvertToSource;
            return this;
        }

        /**
         * Sets whether the fluid can push an entity.
         */
        public Properties canPushEntity(boolean canPushEntity) {
            this.canPushEntity = canPushEntity;
            return this;
        }

        /**
         * Sets whether the fluid can be swum in.
         */
        public Properties canSwim(boolean canSwim) {
            this.canSwim = canSwim;
            return this;
        }

        /**
         * Sets whether the fluid can drown something.
         */
        public Properties canDrown(boolean canDrown) {
            this.canDrown = canDrown;
            return this;
        }

        /**
         * Sets how much the fluid should scale the damage done when hitting
         * the ground per tick.
         */
        public Properties fallDistanceModifier(float fallDistanceModifier) {
            this.fallDistanceModifier = fallDistanceModifier;
            return this;
        }

        /**
         * Sets whether the fluid can extinguish.
         */
        public Properties canExtinguish(boolean canExtinguish) {
            this.canExtinguish = canExtinguish;
            return this;
        }

        /**
         * Sets whether the fluid supports boating.
         */
        public Properties supportsBoating(boolean supportsBoating) {
            this.supportsBoating = supportsBoating;
            return this;
        }

        /**
         * Sets the path type of this fluid.
         *
         * @param pathType the path type of this fluid
         * @return the property holder instance
         */
        public Properties pathType(@Nullable class_7 pathType) {
            this.pathType = pathType;
            return this;
        }

        /**
         * Sets the path type of the adjacent fluid. Path types with a negative
         * malus are not traversable. Pathfinding will favor paths consisting of
         * a lower malus.
         *
         * @param adjacentPathType the path type of this fluid
         * @return the property holder instance
         */
        public Properties adjacentPathType(@Nullable class_7 adjacentPathType) {
            this.adjacentPathType = adjacentPathType;
            return this;
        }

        /**
         * Sets a sound to play when a certain action is performed. Actions id have to match forge ones. I.e: "bucket_fill"
         */
        public Properties sound(String soundActionId, class_3414 sound) {
            this.sounds.put(soundActionId, sound);
            return this;
        }

        /**
         * Sets whether the fluid can hydrate.
         *
         * <p>Hydration is an arbitrary word which depends on the implementation.
         */
        public Properties canHydrate(boolean canHydrate) {
            this.canHydrate = canHydrate;
            return this;
        }

        /**
         * Sets the light level emitted by the fluid.
         */
        public Properties lightLevel(int lightLevel) {
            this.lightLevel = lightLevel;
            return this;
        }

        /**
         * Sets the density of the fluid.
         */
        public Properties density(int density) {
            this.density = density;
            return this;
        }

        /**
         * Sets the temperature of the fluid.
         */
        public Properties temperature(int temperature) {
            this.temperature = temperature;
            return this;
        }

        /**
         * Sets the viscosity, or thickness, of the fluid.
         */
        public Properties viscosity(int viscosity) {
            this.viscosity = viscosity;
            return this;
        }

        /**
         * Sets the rarity of the fluid.
         */
        public Properties rarity(class_1814 rarity) {
            this.rarity = rarity;
            return this;
        }
    }

}
