package net.mehvahdjukaar.moonlight.api.fluids;

import ;
import B;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper.Type;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.fluid.SoftFluidInternal;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1920;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

// do NOT have these in a static field as they contain registry holders
public class SoftFluidStack {

    public static final Codec<SoftFluidStack> CODEC = RecordCodecBuilder.create(i -> i.group(
            SoftFluid.HOLDER_CODEC.fieldOf("id").forGetter(SoftFluidStack::getHolder),
            Codec.INT.optionalFieldOf("count", 1).forGetter(SoftFluidStack::getCount),
            class_2487.field_25128.optionalFieldOf("tag").forGetter(fluidStack -> Optional.ofNullable(fluidStack.getTag()))
    ).apply(i, SoftFluidStack::fromCodec));

    // dont access directly
    private final class_6880<SoftFluid> fluidHolder;
    private final SoftFluid fluid; //reference to avoid calling value all the times. these 2 should always match
    private int count;
    @Nullable
    private class_2487 tag;
    private boolean isEmptyCache;

    //TODO: make abstract and internal
    @ApiStatus.Internal
    @Deprecated(forRemoval = true) //not for removal just make abstract
    public SoftFluidStack(class_6880<SoftFluid> fluid, int count, @Nullable class_2487 tag) {
        this.fluidHolder = fluid;
        this.fluid = this.fluidHolder.comp_349();
        this.tag = tag;
        this.count = count;
        this.updateEmpty();

        //even more hardcoded shit
        if (fluid.method_40226(BuiltInSoftFluids.POTION.getID())) {
            if (this.tag == null || PotionNBTHelper.getPotionType(this.tag) == null) {
                PotionNBTHelper.Type.REGULAR.applyToTag(this.getOrCreateTag());
            }
        }
    }

    @Deprecated(forRemoval = true)
    public SoftFluidStack(class_6880<SoftFluid> fluid, int count) {
        this(fluid, count, null);
    }

    private static SoftFluidStack fromCodec(class_6880<SoftFluid> fluid, Integer count, Optional<class_2487> optionalTag) {
        return of(fluid, count, optionalTag.orElse(null));
    }

    public static SoftFluidStack loadFromBuffer(class_2540 buf) {
        if (!buf.readBoolean()) {
            return SoftFluidStack.empty();
        }
        class_2378<SoftFluid> reg = SoftFluidRegistry.hackyGetRegistry();
        SoftFluid f = buf.method_42064(reg);
        int i = buf.readByte();
        var nbt = buf.method_10798();
        return of(reg.method_47983(f), i, nbt);
    }

    public void saveToBuffer(class_2540 buf) {
        if (this.isEmpty()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            buf.method_42065(SoftFluidRegistry.hackyGetRegistry(), fluid);
            buf.writeByte(this.getCount());
            class_2487 compoundTag = this.getTag();

            buf.method_10794(compoundTag);
        }
    }

    @Deprecated(forRemoval = true)
    public SoftFluidStack(class_6880<SoftFluid> fluid) {
        this(fluid, 1, null);
    }

    @ExpectPlatform
    public static SoftFluidStack of(class_6880<SoftFluid> fluid, int count, @Nullable class_2487 tag) {
        throw new AssertionError();
    }

    public static SoftFluidStack of(class_6880<SoftFluid> fluid, int count) {
        return of(fluid, count, null);
    }

    public static SoftFluidStack of(class_6880<SoftFluid> fluid) {
        return of(fluid, 1, null);
    }

    public static SoftFluidStack bucket(class_6880<SoftFluid> fluid) {
        return of(fluid, SoftFluid.BUCKET_COUNT);
    }

    public static SoftFluidStack bowl(class_6880<SoftFluid> fluid) {
        return of(fluid, SoftFluid.BOWL_COUNT);
    }

    public static SoftFluidStack bottle(class_6880<SoftFluid> fluid) {
        return of(fluid, SoftFluid.BOTTLE_COUNT);
    }

    public static SoftFluidStack empty() {
        return of(SoftFluidRegistry.getEmpty(), 0, null);
    }

    public class_2487 save(class_2487 compoundTag) {
        compoundTag.method_10582("id", getHolder().method_40230().get().method_29177().toString());
        compoundTag.method_10567("count", (byte) this.count);
        if (this.tag != null) {
            compoundTag.method_10566("tag", this.tag.method_10553());
        }
        return compoundTag;
    }

    public static SoftFluidStack load(class_2487 tag) {
        //backwards compat
        if (tag.method_10545("Fluid")) {
            tag.method_10582("id", tag.method_10558("Fluid"));
            tag.method_10551("Fluid");
        }
        if (tag.method_10545("NBT")) {
            tag.method_10566("tag", tag.method_10580("NBT"));
            tag.method_10551("NBT");
        }
        if (tag.method_10545("Count")) {
            tag.method_10567("count", (byte) tag.method_10550("Count"));
            tag.method_10551("count");
        }

        var fluid = SoftFluidRegistry.getHolder(new class_2960(tag.method_10558("id")));
        var amount = tag.method_10571("count");
        class_2487 nbt = null;
        if (tag.method_10573("tag", 10)) {
            nbt = tag.method_10562("tag");
        }
        return of(fluid, amount, nbt);
    }

    public boolean is(class_6862<SoftFluid> tag) {
        return getHolder().method_40220(tag);
    }

    public boolean is(class_5321<SoftFluid> location) {
        return getHolder().method_40225(location);
    }

    @Deprecated(forRemoval = true)
    public boolean is(SoftFluid fluid) {
        return this.fluid() == fluid;
    }

    public boolean is(class_6880<SoftFluid> fluid) {
        return fluid == this.fluidHolder || fluid.method_40225(this.fluidKey());
    }

    @Deprecated(forRemoval = true)    //just make private
    public final class_6880<SoftFluid> getFluid() {
        return isEmptyCache ? SoftFluidRegistry.getEmpty() : fluidHolder;
    }

    public final class_6880<SoftFluid> getHolder() {
        return isEmptyCache ? SoftFluidRegistry.getEmpty() : fluidHolder;
    }

    public final SoftFluid fluid() {
        return isEmptyCache ? SoftFluidRegistry.empty() : fluid;
    }

    public final class_5321<SoftFluid> fluidKey() {
        return getHolder().method_40230().get();
    }

    public boolean isEmpty() {
        return isEmptyCache;
    }

    protected void updateEmpty() {
        isEmptyCache = count <= 0 || BuiltInSoftFluids.EMPTY.is(fluidHolder);
    }

    public int getCount() {
        return isEmptyCache ? 0 : count;
    }

    public void setCount(int count) {
        if (BuiltInSoftFluids.EMPTY.is(fluidHolder)) {
            if (PlatHelper.isDev()) throw new AssertionError();
            return;
        }
        this.count = count;
        this.updateEmpty();
    }

    public void grow(int amount) {
        setCount(this.count + amount);
    }

    public void shrink(int amount) {
        setCount(this.count - amount);
    }

    public boolean hasTag() {
        return tag != null;
    }

    @Nullable
    public class_2487 getTag() {
        return tag;
    }

    public void setTag(@Nullable class_2487 tag) {
        if (BuiltInSoftFluids.EMPTY.is(fluidHolder)) {
            if (PlatHelper.isDev()) throw new AssertionError();
            return;
        }
        this.tag = tag;
    }

    public class_2487 getOrCreateTag() {
        if (tag == null) setTag(new class_2487());
        return tag;
    }

    public class_2487 getOrCreateTagElement(String key) {
        if (this.tag != null && this.tag.method_10573(key, 10)) {
            return this.tag.method_10562(key);
        } else {
            class_2487 compoundTag = new class_2487();
            this.addTagElement(key, compoundTag);
            return compoundTag;
        }
    }

    public void addTagElement(String key, class_2520 tag) {
        this.getOrCreateTag().method_10566(key, tag);
    }

    public SoftFluidStack copy() {
        return of(getHolder(), count, tag == null ? null : tag.method_10553());
    }

    public SoftFluidStack copyWithCount(int count) {
        SoftFluidStack stack = this.copy();
        if (!stack.isEmpty()) {
            stack.setCount(count);
        }
        return stack;
    }

    public SoftFluidStack split(int amount) {
        int i = Math.min(amount, this.getCount());
        SoftFluidStack stack = this.copyWithCount(i);
        if (!this.isEmpty()) this.shrink(i);
        return stack;
    }

    /**
     * Checks if the fluids and NBT Tags are equal. This does not check amounts.
     */
    public boolean isFluidEqual(SoftFluidStack other) {
        return fluid() == other.fluid() && isFluidStackTagEqual(other);
    }

    /**
     * Just checks if nbt is the same
     */
    public boolean isFluidStackTagEqual(SoftFluidStack other) {
        return Objects.equals(this.tag, other.tag);
    }

    // these do not take count into account for some reason
    @Override
    public final int hashCode() {
        int code = 1;
        code = 31 * code + fluid().hashCode();
        if (tag != null)
            code = 31 * code + tag.hashCode();
        return code;
    }

    /**
     * Default equality comparison for a FluidStack. Same functionality as isFluidEqual().
     * <p>
     * This is included for use in data structures.
     */
    @Override
    public final boolean equals(Object o) {
        if (o instanceof SoftFluidStack ss) {
            return isFluidEqual(ss);
        }
        return false;
    }

    @Override
    public String toString() {
        String s = count + " " + getHolder().method_40230().get().method_29177();
        if (tag != null) s += " [" + tag + "]";
        return s;
    }

    @NotNull
    public static SoftFluidStack fromFluid(class_3611 fluid, int amount, @Nullable class_2487 tag) {
        class_6880<SoftFluid> f = SoftFluidInternal.fromVanillaFluid(fluid, Utils.hackyGetRegistryAccess());
        if (f == null) return empty();
        return of(f, amount, tag);
    }

    @NotNull
    public static SoftFluidStack fromFluid(class_3610 fluid) {
        if (fluid.method_15767(class_3486.field_15517)) {
            return fromFluid(fluid.method_15772(), SoftFluid.WATER_BUCKET_COUNT, null);
        }
        return fromFluid(fluid.method_15772(), SoftFluid.BUCKET_COUNT, null);
    }


    // item conversion

    @Nullable
    public static Pair<SoftFluidStack, FluidContainerList.Category> fromItem(class_1799 itemStack) {
        class_1792 filledContainer = itemStack.method_7909();
        class_6880<SoftFluid> fluid = SoftFluidInternal.fromVanillaItem(filledContainer, Utils.hackyGetRegistryAccess());

        if (fluid != null && !BuiltInSoftFluids.EMPTY.is(fluid)) {
            var category = fluid.comp_349().getContainerList()
                    .getCategoryFromFilled(filledContainer);

            if (category.isPresent()) {

                int count = category.get().getCapacity();

                class_2487 fluidTag = new class_2487();

                class_2487 itemTag = itemStack.method_7969();

                //convert potions to water bottles
                class_1842 potion = class_1844.method_8063(itemStack);
                boolean hasCustomPot = (itemTag != null && itemTag.method_10545("CustomPotionEffects"));
                if (potion == class_1847.field_8991 && !hasCustomPot) {
                    fluid = BuiltInSoftFluids.WATER.getHolder();
                }
                //add tags to splash and lingering potions
                else if (potion != class_1847.field_8984 || hasCustomPot) {
                    PotionNBTHelper.Type type = PotionNBTHelper.getPotionType(filledContainer);
                    if (type == null) type = PotionNBTHelper.Type.REGULAR;
                    type.applyToTag(fluidTag);
                }

                //copy nbt from item
                if (itemTag != null) {
                    for (String k : fluid.comp_349().getNbtKeyFromItem()) {
                        class_2520 c = itemTag.method_10580(k);
                        if (c != null) {
                            fluidTag.method_10566(k, c);
                        }
                    }
                }

                if (fluidTag.method_33133()) fluidTag = null;

                return Pair.of(SoftFluidStack.of(fluid, count, fluidTag), category.get());
            }
        }
        return null;
    }


    @Deprecated(forRemoval = true)
    public Pair<class_1799, FluidContainerList.Category> toItem(class_1799 emptyContainer, boolean dontModifyStack) {
        var r = toItem(emptyContainer);
        if (r != null && !dontModifyStack) this.shrink(r.getSecond().getCapacity());
        return r;
    }

    /**
     * Converts to item and decrement the stack by extracted amount
     */
    public Pair<class_1799, FluidContainerList.Category> splitToItem(class_1799 emptyContainer) {
        var r = toItem(emptyContainer);
        if (r != null) this.shrink(r.getSecond().getCapacity());
        return r;
    }

    /**
     * Fills the item if possible. Returns empty stack if it fails
     *
     * @param emptyContainer empty bottle item
     * @return null if it fails, filled stack otherwise
     */
    @Nullable
    public Pair<class_1799, FluidContainerList.Category> toItem(class_1799 emptyContainer) {
        var opt = fluid().getContainerList().getCategoryFromEmpty(emptyContainer.method_7909());
        if (opt.isPresent()) {
            FluidContainerList.Category category = opt.get();
            var filledStacks = createFilledStacks(category, true);
            if (filledStacks.length != 0) {
                // still return only the *first* one, to stay consistent
                return Pair.of(filledStacks[0], category);
            }
        }
        return null;
    }

    public Multimap<FluidContainerList.Category, class_1799> toAllPossibleFilledItems() {
        Multimap<FluidContainerList.Category, class_1799> result = ArrayListMultimap.create();

        for (FluidContainerList.Category category : fluid().getContainerList()) {
            for (class_1799 filled : createFilledStacks(category, false)) {
                result.put(category, filled);
            }
        }

        return result;
    }

    private class_1799[] createFilledStacks(FluidContainerList.Category category, boolean onlyFirst) {
        int shrinkAmount = category.getCapacity();
        if (shrinkAmount > this.getCount()) {
            return new class_1799[0];
        }

        List<class_1799> results = new ArrayList<>();

        for (class_1935 item : category.getFilledItems()) {
            class_1799 filledStack = new class_1799(item);

            //case for lingering potions
            if (this.is(BuiltInSoftFluids.POTION.getHolder()) && this.tag != null) {
                var type = PotionNBTHelper.getPotionType(this.tag);
                if (type != null && !Utils.getID(category.getEmptyContainer()).method_12836().equals("inspirations")) {
                    if (type != PotionNBTHelper.Type.REGULAR) {
                        filledStack = type.getDefaultItem();
                    }
                }
            }

            // converts water bottles into potions
            if (category.getEmptyContainer() == class_1802.field_8469 && this.is(BuiltInSoftFluids.WATER)) {
                filledStack = class_1844.method_8061(new class_1799(class_1802.field_8574), class_1847.field_8991);
            }

            this.applyNBTtoItemStack(filledStack);
            results.add(filledStack);

            if (onlyFirst) {
                break;
            }
        }

        return results.toArray(new class_1799[0]);
    }


    //TODO: clean this nbt hardcoded stuff up

    //handles special nbt items such as potions or soups
    protected void applyNBTtoItemStack(class_1799 stack) {
        List<String> nbtKey = this.fluid().getNbtKeyFromItem();
        if (this.tag != null && !this.tag.method_33133()) {
            class_2487 newCom = new class_2487();
            for (String s : nbtKey) {
                //ignores bottle tag, handled separately since it's a diff item
                class_2520 c = this.tag.method_10580(s);
                if (c != null && !s.equals(PotionNBTHelper.POTION_TYPE_KEY)) {
                    newCom.method_10566(s, c);
                }
            }
            if (!newCom.method_33133()) stack.method_7980(newCom);
        }
    }


    // fluid delegates

    public FluidContainerList getContainerList() {
        return fluid().getContainerList();
    }

    public FoodProvider getFoodProvider() {
        return fluid().getFoodProvider();
    }

    public boolean isEquivalent(class_3611 fluid) {
        return this.fluid().isEquivalent(fluid);
    }

    public class_3611 getVanillaFluid() {
        return this.fluid().getVanillaFluid();
    }

    /**
     * Client only
     *
     * @return tint color to be applied on the fluid texture
     */
    public int getStillColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        SoftFluid fluid = this.fluid();
        SoftFluid.TintMethod method = fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.NO_TINT) return -1;
        int specialColor = SoftFluidColors.getSpecialColor(this, world, pos);

        if (specialColor != 0) return specialColor;
        return fluid.getTintColor();
    }

    /**
     * Client only
     *
     * @return tint color to be applied on the fluid texture
     */
    public int getFlowingColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        SoftFluid.TintMethod method = this.fluid().getTintMethod();
        if (method == SoftFluid.TintMethod.FLOWING) return this.getParticleColor(world, pos);
        else return this.getStillColor(world, pos);
    }

    /**
     * Client only
     *
     * @return tint color to be used on particle. Differs from getTintColor since it returns an mixWith color extrapolated from their fluid textures
     */
    public int getParticleColor(@Nullable class_1920 world, @Nullable class_2338 pos) {
        int tintColor = getStillColor(world, pos);
        //if tint color is white gets averaged color
        if (tintColor == -1) return this.fluid().getAverageTextureTintColor();
        return tintColor;
    }

}
