package net.mehvahdjukaar.moonlight.api.item;

import dev.architectury.injectables.annotations.PlatformOnly;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_3956;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;

public class FuelBlockItem extends class_1747 {
    private final Supplier<Integer> burnTime;

    public FuelBlockItem(class_2248 pBlock, class_1793 pProperties, Supplier<Integer> burnTime) {
        super(pBlock, pProperties);
        this.burnTime = burnTime;
        PlatHelper.getPlatform().ifFabric(() -> {
            int b = burnTime.get();
            //this won't work for non-vanilla base items... too bad
            if (b != 0) RegHelper.registerItemBurnTime(this, b);
        });
    }

    @PlatformOnly(PlatformOnly.FORGE)
    public int getBurnTime(class_1799 itemStack, @Nullable class_3956<?> recipeType) {
        return burnTime.get();
    }
}