package net.mehvahdjukaar.moonlight.api.item;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedItem;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3881;
import net.minecraft.class_3882;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_583;

public interface IThirdPersonSpecialItemRenderer {

    /**
     * Use this interface to have more control of how your item is rendered in third person.
     * This is useful for items that should render relative to a body part that is not the hand like spyglass.
     * See ItemInHandLayer or PlayerItemInHandLayer classes for its vanilla default implementations
     * See this as a sort of enhanced third person only ISTER
     * Note that this only works for players (at least for now)
     *
     * @param parentModel  model of the entity that is rendering this item
     * @param entity       entity being rendered
     * @param stack        item stack
     * @param humanoidArm  can be either HumanoidLeft or HumanoidRight
     * @param poseStack    matrix stack
     * @param bufferSource buffer
     * @param light        combined light
     */
    <T extends class_1657, M extends class_583<T> & class_3881 & class_3882> void renderThirdPersonItem(
            M parentModel, class_1309 entity, class_1799 stack,
            class_1306 humanoidArm, class_4587 poseStack, class_4597 bufferSource, int light);


    /**
     * Alternatively, if you don't own the item and cant implement this interface in it you can use this call to attach your interface to an item
     * Note that when using other any of these 3 extensions only 1 object can be attached to any item, so be sure what you attach implements all of them
     */
    static void attachToItem(class_1792 target, IThirdPersonSpecialItemRenderer object) {
        if (PlatHelper.getPhysicalSide().isClient()) {
            IExtendedItem extendedItem = (IExtendedItem) target;
            if (extendedItem.moonlight$getClientAnimationExtension() != null) {
                if (PlatHelper.isDev())
                    throw new AssertionError("A client animation extension was already registered for this item");
            }
            extendedItem.moonlight$setClientAnimationExtension(object);
        }
    }

    static IThirdPersonSpecialItemRenderer get(class_1792 target) {
        if (target instanceof IThirdPersonSpecialItemRenderer p) return p;
        if (((IExtendedItem) target).moonlight$getClientAnimationExtension() instanceof IThirdPersonSpecialItemRenderer p)
            return p;
        return null;
    }

}
