package net.mehvahdjukaar.moonlight.api.item.additional_placements;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.misc.IExtendedItem;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AdditionalItemPlacementsAPI {

    private static boolean isAfterRegistration = false;
    private static WeakReference<Map<class_2248, class_1792>> blockToItemsMap = new WeakReference<>(null);

    private static final List<Consumer<Event>> REGISTRATION_LISTENERS = Collections.synchronizedList(new ArrayList<>());;

    private static final List<Pair<Supplier<? extends AdditionalItemPlacement>, Supplier<? extends class_1792>>> PLACEMENTS = new ArrayList<>();
    private static final List<Pair<Function<class_1792, ? extends AdditionalItemPlacement>, Predicate<class_1792>>> PLACEMENTS_GENERIC = new ArrayList<>();

    /**
     * Adds a behavior to an existing block. can be called at any time but ideally before registration. Less ideally during mod setup
     */
    @Deprecated(forRemoval = true)
    public static void register(Supplier<? extends AdditionalItemPlacement> placement, Supplier<? extends class_1792> itemSupplier) {
        if (PlatHelper.isDev() && isAfterRegistration) {
            throw new IllegalStateException("Attempted to add placeable behavior after registration");
        }
        PLACEMENTS.add(Pair.of(placement, itemSupplier));
    }

    @Deprecated(forRemoval = true)
    public static void register(Function<class_1792, ? extends AdditionalItemPlacement> placement, Predicate<class_1792> itemPredicate) {
        if (PlatHelper.isDev() && isAfterRegistration) {
            throw new IllegalStateException("Attempted to add placeable behavior after registration");
        }
        PLACEMENTS_GENERIC.add(Pair.of(placement, itemPredicate));
    }

    @Deprecated(forRemoval = true)
    public static void registerSimple(Supplier<? extends class_2248> block, Supplier<? extends class_1792> itemSupplier) {
        register(() -> new AdditionalItemPlacement(block.get()), itemSupplier);
    }

    public static void addRegistration(Consumer<Event> eventConsumer){
        Moonlight.assertInitPhase();
        REGISTRATION_LISTENERS.add(eventConsumer);
    }

    @Nullable
    public static AdditionalItemPlacement getBehavior(class_1792 item) {
        return ((IExtendedItem) item).moonlight$getAdditionalBehavior();
    }

    public static boolean hasBehavior(class_1792 item) {
        return getBehavior(item) != null;
    }


    //needed as all items have to be registered before we can add them to maps. ALso better to do this asap
    @ApiStatus.Internal
    public static void afterItemReg() {
        if (blockToItemsMap.get() == null) {
            if (PlatHelper.isDev()) {
                throw new AssertionError("Block to items map was null");
            }
        }
        //after all registry objects are created we register our stuff
        attemptRegistering();
    }


    private static void attemptRegistering() {
        Map<class_2248, class_1792> map = blockToItemsMap.get();
        if (map != null) {

            for (class_1792 item : class_7923.field_41178) {
                for (var v : PLACEMENTS_GENERIC) {
                    var predicate = v.getSecond();
                    if (predicate.test(item)) {
                        PLACEMENTS.add(Pair.of(() -> v.getFirst().apply(item), () -> item));
                    }
                }
            }
            Event ev = (target, instance) -> PLACEMENTS.add(Pair.of(() -> instance, () -> target));
            for (var l : REGISTRATION_LISTENERS) {
                l.accept(ev);
            }
            PLACEMENTS_GENERIC.clear();
            for (var p : PLACEMENTS) {
                AdditionalItemPlacement placement = p.getFirst().get();
                class_1792 i = p.getSecond().get();
                class_2248 b = placement.getPlacedBlock();

                if (i != null && b != null) {
                    if (i != class_1802.field_8162 && b != class_2246.field_10124) {
                        ((IExtendedItem) i).moonlight$addAdditionalBehavior(placement);
                        if (!map.containsKey(b)) map.put(b, i);
                    } else {
                        throw new AssertionError("Attempted to register an Additional behavior for block "+  b + " using with item " + i);
                    }
                }
            }
        }
    }

    //called just once when registry callbacks fire for items. once since we just have 1 item that we use to call this.
    static void onRegistryCallback(Map<class_2248, class_1792> pBlockToItemMap) {
        blockToItemsMap = new WeakReference<>(pBlockToItemMap);
        if (isAfterRegistration) {
            //if we are here it means we are in sync phase where maps are re constructured
            attemptRegistering();
            blockToItemsMap.clear();
        }
        isAfterRegistration = true;
    }

    public interface Event {

        void register(class_1792 target, AdditionalItemPlacement instance);

        // Registers default instance to make simple block placement behavior
        default void registerSimple(class_1792 target, class_2248 toPlace) {
            register(target, new AdditionalItemPlacement(toPlace));
        }
    }

}
