package net.mehvahdjukaar.moonlight.api.map;


import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.minecraft.class_1936;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

import java.util.Map;
import java.util.function.Consumer;

public interface ExpandedMapData {

    @ApiStatus.Internal
    Map<String, CustomMapDecoration> getCustomDecorations();

    @ApiStatus.Internal
    Map<String, MapBlockMarker<?>> getCustomMarkers();

    @ApiStatus.Internal
    Map<class_2960, CustomMapData<?>> getCustomData();

    boolean toggleCustomDecoration(class_1936 world, class_2338 pos);

    void resetCustomDecoration();

    int getVanillaDecorationSize();

    <M extends MapBlockMarker<?>> void addCustomMarker(M fromMarker);

    boolean removeCustomMarker(String id);

    class_22 copy();

    void setCustomDecorationsDirty();

    <H extends CustomMapData.DirtyCounter> void setCustomDataDirty(CustomMapData.Type<?> type, Consumer<H> dirtySetter);
}
