package net.mehvahdjukaar.moonlight.api.map;

import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.CustomDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1657;
import net.minecraft.class_22;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class MapDataRegistry {

    public static final class_5321<class_2378<MapDecorationType<?, ?>>> REGISTRY_KEY = MapDataInternal.KEY;

    /**
     * Registers a custom data type to be stored in map data. Type will provide its onw data implementation
     **/
    public static <T extends CustomMapData<?>> CustomMapData.Type<T> registerCustomMapSavedData(CustomMapData.Type<T> type) {
        return MapDataInternal.registerCustomMapSavedData(type);
    }

    public static <T extends CustomMapData<?>> CustomMapData.Type<T> registerCustomMapSavedData(class_2960 id, Supplier<T> factory) {
        return registerCustomMapSavedData(new CustomMapData.Type<>(id, factory));
    }

    public static MapDecorationType<?, ?> getDefaultType() {
        return MapDataInternal.getGenericStructure();
    }

    /**
     * Call before mod setup. Register a code defined map marker type. You will still need to add a related json file
     */
    //TODO: this is bad. rethink type stuff
    //we have instances of markers per map. these have a type which determines their type
    //each type is assigned to one and one only json file. essntally the type is what is parsed from json.
    //each type can intern have its own type.., the custom factory
    @Deprecated(forRemoval = true)
    public static <T extends CustomDecorationType<?, ?>> T registerCustomType(T decorationType) {
         MapDataInternal.registerCustomType(decorationType.getCustomFactoryID(), ()->decorationType);
         return decorationType;
    }

    public static void registerCustomType(class_2960 factoryId, Supplier<CustomDecorationType<?,?>> decorationTypeFactory) {
         MapDataInternal.registerCustomType(factoryId, decorationTypeFactory);
    }

    /**
     * Use to add non-permanent decoration like player icon, only visible to player holding the map.
     * Called by the client every time map marker would change.
     * This means that for moving ones you should manage this yourself with a client tick event
     *
     * @param event callback
     */
    public static void addDynamicClientMarkersEvent(BiFunction<Integer, class_22, Set<MapBlockMarker<?>>> event) {
        MapDataInternal.addDynamicClientMarkersEvent(event);
    }

    /**
     * Use to add non-permanent per-player decoration like player icon, only visible to player holding the map.
     * Called by server every couple minutes and synced to the client.
     * Whether these will be saved or not is up to the marker provided
     *
     * @param event callback
     */
    public static void addDynamicServerMarkersEvent(TriFunction<class_1657, Integer, class_22, Set<MapBlockMarker<?>>> event) {
        MapDataInternal.addDynamicServerMarkersEvent(event);
    }

    public static CustomDecorationType<?, ?> getCustomType(class_2960 resourceLocation) {
        return MapDataInternal.createCustomType(resourceLocation);
    }

    public static MapDecorationType<?, ?> getAssociatedType(class_6880<class_3195> structure) {
        return MapDataInternal.getAssociatedType(structure);
    }

    public static class_2378<MapDecorationType<?, ?>> getRegistry(class_5455 registryAccess) {
        return MapDataInternal.getRegistry(registryAccess);
    }

    public static MapDecorationType<?, ?> get(class_2960 id) {
        return MapDataInternal.get(id);
    }

    public static Optional<MapDecorationType<?, ?>> getOptional(class_2960 id) {
        return MapDataInternal.getOptional(id);
    }

    @Nullable
    public static MapBlockMarker<?> readMarker(class_2487 tag) {
        return MapDataInternal.readWorldMarker(tag);
    }

}
