package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.markers.SimpleMapBlockMarker;
import net.mehvahdjukaar.moonlight.api.misc.StrOpt;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3825;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

//Base type for simple data-driven type. Basically a simple version of CustomDecorationType that can be serialized
public final class JsonDecorationType implements MapDecorationType<CustomMapDecoration, SimpleMapBlockMarker> {


    public static final Codec<JsonDecorationType> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            StrOpt.of(class_3825.field_25012, "target_block").forGetter(JsonDecorationType::getTarget),
            StrOpt.of(Codec.STRING, "name").forGetter(JsonDecorationType::getName),
            StrOpt.of(Codec.INT, "rotation", 0).forGetter(JsonDecorationType::getRotation),
            StrOpt.of(ColorUtils.CODEC, "map_color", 0).forGetter(JsonDecorationType::getDefaultMapColor),
            StrOpt.of(class_6895.method_40340(class_7924.field_41246), "target_structures").forGetter(
                    JsonDecorationType::getAssociatedStructure), Codec.STRING.xmap(PlatHelper::isModLoaded, b -> "minecraft")
                    .optionalFieldOf("from_mod", true)
                    .forGetter(t -> t.enabled)
    ).apply(instance, JsonDecorationType::new));

    //we cant reference other data pack registries in network codec...
    public static final Codec<JsonDecorationType> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group(
            StrOpt.of(class_3825.field_25012, "target_block").forGetter(JsonDecorationType::getTarget),
            StrOpt.of(Codec.STRING, "name").forGetter(JsonDecorationType::getName),
            StrOpt.of(Codec.INT, "rotation", 0).forGetter(JsonDecorationType::getRotation),
            StrOpt.of(ColorUtils.CODEC, "map_color", 0).forGetter(JsonDecorationType::getDefaultMapColor),
            Codec.BOOL.fieldOf("enabled").forGetter(t -> t.enabled)
    ).apply(instance, JsonDecorationType::new));

    //using this and not block predicate since it requires a worldLevelGen...
    @Nullable
    private final class_3825 target;

    @Nullable
    private final String name;
    @Nullable
    private final class_6885<class_3195> structures;
    private final int mapColor;
    private final int rotation;
    private final boolean enabled;

    public JsonDecorationType(Optional<class_3825> target) {
        this(target, Optional.empty(), 0, 0, true);
    }

    public JsonDecorationType(Optional<class_3825> target, Optional<String> name, int rotation,
                              int mapColor, boolean enabled) {
        this(target, name, rotation, mapColor, Optional.empty(), enabled);
    }

    public JsonDecorationType(Optional<class_3825> target, Optional<String> name, int rotation,
                              int mapColor, Optional<class_6885<class_3195>> structure, Boolean enabled) {
        this.target = target.orElse(null);
        this.name = name.orElse(null);
        this.rotation = rotation;
        this.structures = structure.orElse(null);
        this.mapColor = mapColor;
        this.enabled = enabled;
    }


    public Optional<class_3825> getTarget() {
        return Optional.ofNullable(target);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public int getRotation() {
        return rotation;
    }

    public Optional<class_6885<class_3195>> getAssociatedStructure() {
        return Optional.ofNullable(structures);
    }

    public int getDefaultMapColor() {
        return mapColor;
    }

    @Override
    public boolean isFromWorld() {
        return target != null;
    }

    public class_2960 getId() {
        return Utils.getID(this);
    }

    @Nullable
    @Override
    public CustomMapDecoration loadDecorationFromBuffer(class_2540 buffer) {
        try {
            return new CustomMapDecoration(this, buffer);
        } catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + this.getId() + ": " + e);
        }
        return null;
    }

    @Nullable
    @Override
    public SimpleMapBlockMarker loadMarkerFromNBT(class_2487 compound) {
        SimpleMapBlockMarker marker = new SimpleMapBlockMarker(this);
        try {
            marker.loadFromNBT(compound);
            return marker;
        } catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + this.getId() + ": " + e);
        }
        return null;
    }

    @Nullable
    @Override
    public SimpleMapBlockMarker getWorldMarkerFromWorld(class_1922 reader, class_2338 pos) {
        if (this.target != null && enabled) {
            if (target.method_16768(reader.method_8320(pos), class_5819.method_43047())) {
                SimpleMapBlockMarker m = createEmptyMarker();
                m.setPos(pos);
                return m;
            }
        }
        return null;
    }


    @Override
    public SimpleMapBlockMarker createEmptyMarker() {
        var m = new SimpleMapBlockMarker(this);
        m.setRotation(rotation);
        m.setName(name == null ? null : class_2561.method_43471(name));
        return m;
    }

}
