package net.mehvahdjukaar.moonlight.api.map.type;

import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_6885;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

//type itself can have two types: json defined or custom code defined
public interface MapDecorationType<D extends CustomMapDecoration, M extends MapBlockMarker<D>> {

    /**
     * If this marker should be saved to disk
     */
    @ApiStatus.Internal
    boolean isFromWorld();

    default class_2960 getCustomFactoryID() {
        return new class_2960("");
    }

    @Nullable
    D loadDecorationFromBuffer(class_2540 buffer);

    M createEmptyMarker();

    @Nullable
    M loadMarkerFromNBT(class_2487 compound);

    @Nullable
    M getWorldMarkerFromWorld(class_1922 reader, class_2338 pos);

    default int getDefaultMapColor() {
        return 1;
    }

    default Optional<class_6885<class_3195>> getAssociatedStructure() {
        return Optional.empty();
    }

}
