package net.mehvahdjukaar.moonlight.api.misc;

import com.mojang.datafixers.util.Either;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7876;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

//can be statically stored and persists across world loads

/**
 * A soft reference to an object in a Data pack registry
 * Like registry object but can be invalidated and works for data pack registries
 */
public class DynamicHolder<T> implements Supplier<T>, class_6880<T> {

    @ApiStatus.Internal
    public static void clearCache() {
        REFERENCES.forEach(DynamicHolder::invalidateInstance);
    }

    private static final WeakHashSet<DynamicHolder<?>> REFERENCES = new WeakHashSet<>();

    private final class_5321<class_2378<T>> registryKey;
    private final class_5321<T> key;

    // needs to be thread local because of data pack stuff. datapack registries will have 2 objects with the same key
    protected final ThreadLocal<class_6880<T>> instance = new ThreadLocal<>();

    protected DynamicHolder(class_5321<class_2378<T>> registryKey, class_5321<T> key) {
        this.registryKey = registryKey;
        this.key = key;
        REFERENCES.add(this);
    }

    public static <A> DynamicHolder<A> of(String id, class_5321<class_2378<A>> registry) {
        return of(new class_2960(id), registry);
    }

    public static <A> DynamicHolder<A> of(class_2960 location, class_5321<class_2378<A>> registry) {
        return new DynamicHolder<>(registry, class_5321.method_29179(registry, location));
    }

    public static <A> DynamicHolder<A> of(class_5321<A> key) {
        return new DynamicHolder<>(class_5321.method_29180(key.method_41185()), key);
    }

    public static <A> Opt<A> optional(class_2960 location, class_5321<class_2378<A>> registry) {
        return new Opt<>(registry, class_5321.method_29179(registry, location));
    }

    public static <A> Opt<A> optional(class_5321<A> key) {
        return new Opt<>(class_5321.method_29180(key.method_41185()), key);
    }

    public static <A> Opt<A> optional(String id, class_5321<class_2378<A>> registry) {
        return optional(new class_2960(id), registry);
    }

    private void invalidateInstance() {
        instance.remove();
    }

    @NotNull
    protected class_6880<T> getInstance() {
        class_6880<T> value = instance.get();
        if (value == null) {
            var r = Utils.hackyGetRegistryAccess();
            class_2378<T> reg = r.method_30530(registryKey);
            try {
                value = reg.method_40290(key);
                instance.set(value);
            } catch (Exception e) {
                throw new RuntimeException("Failed to get object from registry: " + key +
                        ".\nCalled from " + Thread.currentThread() + ".\n" +
                        "Registry content was: " + reg.method_29722().stream().map(b -> b.getKey().method_29177()).toList(), e);
            }
        }
        return value;
    }

    public String getRegisteredName() {
        return key.method_29177().toString();
    }

    public class_2960 getID() {
        return key.method_29177();
    }

    public class_5321<T> getKey() {
        return key;
    }

    @Deprecated(forRemoval = true)
    @NotNull
    public T get() {
        return comp_349();
    }

    @Override
    public T comp_349() {
        return getInstance().comp_349();
    }

    @Override
    public boolean method_40227() {
        return true;
    }

    @Override
    public boolean method_40226(class_2960 location) {
        return registryKey.method_29177().equals(location);
    }

    @Override
    public boolean method_40225(class_5321<T> resourceKey) {
        return resourceKey == key;
    }

    @Override
    public boolean method_40224(Predicate<class_5321<T>> predicate) {
        return predicate.test(key);
    }

    public boolean is(class_6880<T> other) {
        return other == this || other.method_40230().get() == key;
    }

    @Override
    public boolean method_40220(class_6862<T> tagKey) {
        return getInstance().method_40220(tagKey);
    }

    @Override
    public Stream<class_6862<T>> method_40228() {
        return getInstance().method_40228();
    }

    @Override
    public Either<class_5321<T>, T> method_40229() {
        return Either.left(this.key);
    }

    @Override
    public Optional<class_5321<T>> method_40230() {
        return Optional.of(key);
    }

    @Override
    public class_6882 method_40231() {
        return class_6880.class_6882.field_36446;
    }

    @Override
    public boolean method_46745(class_7876<T> owner) {
        return getInstance().method_46745(owner);
    }

    public static class Opt<T> extends DynamicHolder<T> {
        private boolean resolved = false;

        protected Opt(class_5321<class_2378<T>> registryKey, class_5321<T> key) {
            super(registryKey, key);
        }

        @Nullable
        @Override
        protected class_6880<T> getInstance() {
            if (!resolved) {
                resolved = true;
                try {
                    return super.getInstance();
                } catch (Exception ignored) {
                }
            }
            return instance.get();
        }

        @Override
        public Stream<class_6862<T>> method_40228() {
            var i = getInstance();
            if (i != null) return i.method_40228();
            return Stream.empty();
        }

        @Override
        public boolean method_40220(class_6862<T> tagKey) {
            var i = getInstance();
            if (i != null) return i.method_40220(tagKey);
            return false;
        }

        @Nullable
        @Override
        public T get() {
            return super.get();
        }

        @Nullable
        @Override
        public T comp_349() {
            var i = getInstance();
            if (i != null) return i.comp_349();
            return null;
        }
    }
}
