package net.mehvahdjukaar.moonlight.api.platform.configs.fabric;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.loader.api.FabricLoader;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * Main config screen
 */
public class FabricConfigListScreen extends class_437 {

    protected final class_437 parent;
    protected final ConfigSpec[] configs;
    @Nullable
    protected final class_2960 background;
    private final class_1799 mainIcon;
    private final String modId;
    private final String modURL;

    protected ConfigList list;

    public FabricConfigListScreen(String modId, class_1799 mainIcon, class_2561 displayName, @Nullable class_2960 background,
                                  class_437 parent,
                                  ConfigSpec... specs) {
        super(displayName);
        this.parent = parent;
        this.configs = specs;
        this.background = background;
        this.mainIcon = mainIcon;
        this.modId = modId;
        this.modURL = FabricLoader.getInstance().getModContainer(modId).get().getMetadata().getContact().get("homepage").orElse(null);
    }

    @Override
    protected void method_25426() {
        this.list = new ConfigList(this.field_22787, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 40,
                this.configs);
        this.method_37063(this.list);

        this.addExtraButtons();
    }

    protected void addExtraButtons() {
        this.method_37063(class_4185.method_46430(
                        class_5244.field_24334, button -> this.field_22787.method_1507(this.parent))
                .method_46434(this.field_22789 / 2 - 155 + 160, this.field_22790 - 29, 150, 20).method_46431());
    }

    @Override
    public void method_25432() {
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 15, 16777215);

        if (modURL != null && isMouseWithin((this.field_22789 / 2) - 90, 2 + 6, 180, 16 + 2, mouseX, mouseY)) {
            graphics.method_51447(this.field_22793, this.field_22793.method_1728(class_2561.method_43469("gui.moonlight.open_mod_page", this.modId), 200), mouseX, mouseY);
        }
        int titleWidth = this.field_22793.method_27525(this.field_22785) + 35;
        graphics.method_51445(this.mainIcon, (this.field_22789 / 2) + titleWidth / 2 - 17, 2 + 8);
        graphics.method_51445(this.mainIcon, (this.field_22789 / 2) - titleWidth / 2, 2 + 8);
    }

    private boolean isMouseWithin(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (modURL != null && isMouseWithin((this.field_22789 / 2) - 90, 2 + 6, 180, 16 + 2, (int) mouseX, (int) mouseY)) {
            class_2583 style = class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11749, modURL));
            this.method_25430(style);
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    protected class ConfigList extends class_4265<ConfigButton> {

        public ConfigList(class_310 minecraft, int width, int height, int y0, int y1, int itemHeight, ConfigSpec... specs) {
            super(minecraft, width, height, y0, y1, itemHeight);
            this.field_22744 = true;
            this.method_29344(false);
            for (var s : specs) {
                this.method_25321(new ConfigButton(s, this.field_22742, this.method_25322()));
            }
        }

        @Override
        public int method_25322() {
            return 260;
        }

        @Override
        protected int method_25329() {
            return super.method_25329() + 32;
        }

        /*
        @Override
        protected int getRowTop(int index) {
            if (!this.centerListVertically) return super.getRowTop(index);
            return (y1 - y0) / 2 - (this.children().size() * itemHeight) / 2 +
                    this.y0 + 4 - (int) this.getScrollAmount() + index * this.itemHeight + this.headerHeight;
        }*/

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            this.method_25325(graphics);

            var background = FabricConfigListScreen.this.background;
            if (background == null) background = class_437.field_44669;

            int i = this.method_25329();
            int j = i + 6;
            //this.hovered = this.isMouseOver((double)mouseX, (double)mouseY) ? this.getEntryAtPosition((double)mouseX, (double)mouseY) : null;
            if (true) {
                RenderSystem.setShaderColor(0.125F, 0.125F, 0.125F, 1.0F);
                graphics.method_25290(background, this.field_19088, this.field_19085, this.field_19087, (this.field_19086 + (int) this.method_25341()), this.field_19087 - this.field_19088, this.field_19086 - this.field_19085, 32, 32);
                RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
            }

            int k = this.method_25342();
            int l = this.field_19085 + 4 - (int) this.method_25341();
            this.method_49603(graphics);
            if (true) {
                this.method_25312(graphics, k, l);
            }

            this.method_25311(graphics, mouseX, mouseY, partialTick);
            graphics.method_44380();
            if (true) {
                RenderSystem.setShaderColor(0.25F, 0.25F, 0.25F, 1.0F);
                graphics.method_25290(background, this.field_19088, 0, 0.0F, 0.0F, this.field_22742, this.field_19085, 32, 32);
                graphics.method_25290(background, this.field_19088, this.field_19086, 0.0F, this.field_19086, this.field_22742, this.field_22743 - this.field_19086, 32, 32);
                RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
                graphics.method_25296(this.field_19088, this.field_19085, this.field_19087, this.field_19085 + 4, -16777216, 0);
                graphics.method_25296(this.field_19088, this.field_19086 - 4, this.field_19087, this.field_19086, 0, -16777216);
            }

            int m = this.method_25331();
            if (m > 0) {
                int n = (int) ((float) ((this.field_19086 - this.field_19085) * (this.field_19086 - this.field_19085)) / (float) this.method_25317());
                n = class_3532.method_15340(n, 32, this.field_19086 - this.field_19085 - 8);
                int o = (int) this.method_25341() * (this.field_19086 - this.field_19085 - n) / m + this.field_19085;
                if (o < this.field_19085) {
                    o = this.field_19085;
                }

                graphics.method_25294(i, this.field_19085, j, this.field_19086, -16777216);
                graphics.method_25294(i, o, j, o + n, -8355712);
                graphics.method_25294(i, o, j - 1, o + n - 1, -4144960);
            }

            this.method_25320(graphics, mouseX, mouseY);
            RenderSystem.disableBlend();
        }
    }

    protected class ConfigButton extends class_4265.class_4266<ConfigButton> {

        private final List<class_339> children;

        private ConfigButton(class_339 widget) {
            this.children = List.of(widget);
        }

        protected ConfigButton(ConfigSpec spec, int width, int buttonWidth) {
            this(class_4185.method_46430(class_2561.method_43470(spec.getFileName()), b ->
                    class_310.method_1551().method_1507(spec.makeScreen(FabricConfigListScreen.this, FabricConfigListScreen.this.background))
            ).method_46434(width / 2 - buttonWidth / 2, 0, buttonWidth, 20).method_46431());
        }

        @Override
        public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            this.children.forEach((button) -> {
                button.method_46419(top);
                button.method_25394(graphics, mouseX, mouseY, partialTick);
            });
        }

        @Override
        public List<? extends class_364> method_25396() {
            return this.children;
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return this.children;
        }
    }

}