package net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values;

import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.ConfigEntry;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.function.Supplier;

public abstract class ConfigValue<T> extends ConfigEntry implements Supplier<T> {

    protected final T defaultValue;
    protected T value;
    private String translationKey;
    private String descriptionKey;

    protected ConfigValue(String name, T defaultValue) {
        super(name);
        this.defaultValue = defaultValue;
        if (!(this instanceof ObjectConfigValue<T>) && !(this instanceof JsonConfigValue)) {
            Objects.requireNonNull(defaultValue, "default value cant be null");
        }
    }

    public T getDefaultValue() {
        return defaultValue;
    }

    public abstract boolean isValid(T value);

    public void set(T newValue) {
        this.value = newValue;
    }

    @Override
    public T get() {
        return value;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    public void setTranslationKey(String translationKey) {
        this.translationKey = translationKey;
    }

    public class_2561 getTranslation() {
        return class_2561.method_43471(translationKey);
    }

    @Nullable
    public class_2561 getDescription() {
        if (this.descriptionKey == null) return null;
        return class_2561.method_43471(descriptionKey);
    }


}
