package net.mehvahdjukaar.moonlight.api.platform.network.fabric;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntSupplier;

public class ChannelHandlerImpl extends ChannelHandler {

    private static final Map<Class<?>, class_2960> ID_MAP = new HashMap<>();

    public static ChannelHandler createChannel(String modID, IntSupplier version) {
        return new ChannelHandlerImpl(modID);
    }

    private int id = 0;

    public ChannelHandlerImpl(String modId) {
        super(modId);
    }

    @Override
    public <M extends Message> void register(
            NetworkDir direction,
            Class<M> messageClass,
            Function<class_2540, M> decoder) {

        class_2960 res = new class_2960(name, String.valueOf(id++));
        ID_MAP.put(messageClass, res);

        if (direction != NetworkDir.PLAY_TO_CLIENT) {
            ServerPlayNetworking.registerGlobalReceiver(
                    res, (server, player, h, buf, r) -> {
                        M message = decoder.apply(buf);
                        server.execute(() -> message.handle(new Wrapper(player, NetworkDir.PLAY_TO_SERVER, h)));
                    });
        }

        if (direction != NetworkDir.PLAY_TO_SERVER) {
            if (PlatHelper.getPhysicalSide().isClient()) FabricClientNetwork.register(res, decoder);
        }
    }


    static class Wrapper implements Context {

        private final class_1657 player;
        private final NetworkDir dir;
        @Nullable
        private final class_3244 packetListener;

        public Wrapper(class_1657 player, NetworkDir dir, class_3244 packetListener) {
            this.player = player;
            this.dir = dir;
            this.packetListener = packetListener;
        }

        @Override
        public NetworkDir getDirection() {
            return dir;
        }

        @Override
        public class_1657 getSender() {
            return player;
        }

        @Override
        public void disconnect(class_2561 reason) {
            if (packetListener != null) packetListener.method_14367(reason);
            else if (PlatHelper.isDev()) throw new AssertionError("Cant disconnect on client");
        }
    }

    @Override
    public void sendToClientPlayer(class_3222 serverPlayer, Message message) {
        //for (ServerPlayer player : PlayerLookup.tracking(entity)) {
        class_2540 buf = PacketByteBufs.create();
        message.writeToBuffer(buf);
        ServerPlayNetworking.send(serverPlayer, ID_MAP.get(message.getClass()), buf);
        // }
    }

    @Override
    public void sendToAllClientPlayers(Message message) {
        for (var p : PlatHelper.getCurrentServer().method_3760().method_14571()) {
            sendToClientPlayer(p, message);
        }
    }

    @Override
    public void sendToServer(Message message) {
        class_2540 buf = PacketByteBufs.create();
        message.writeToBuffer(buf);
        ClientPlayNetworking.send(ID_MAP.get(message.getClass()), buf);
    }

    @Override
    public void sendToAllClientPlayersInRange(class_1937 level, class_2338 pos, double radius, Message message) {

        MinecraftServer currentServer = PlatHelper.getCurrentServer();
        if (!level.field_9236 && currentServer != null) {
            class_3324 players = currentServer.method_3760();
            var dimension = level.method_27983();

            players.method_14605(null, pos.method_10263(), pos.method_10264(), pos.method_10260(),
                    radius, dimension, toVanillaPacket(message));
        } else if (PlatHelper.isDev()) throw new AssertionError("Cant send message to clients from client side");
    }

    @Override
    public void sentToAllClientPlayersTrackingEntity(class_1297 target, Message message) {
        if (target.method_37908() instanceof class_3218 serverLevel) {
            serverLevel.method_14178().method_18754(target, toVanillaPacket(message));
        } else if (PlatHelper.isDev()) throw new AssertionError("Cant send message to clients from client side");
    }

    @Override
    public void sentToAllClientPlayersTrackingEntityAndSelf(class_1297 target, Message message) {
        if (target.method_37908() instanceof class_3218 serverLevel) {
            var p = toVanillaPacket(message);
            serverLevel.method_14178().method_18754(target, p);
            if (target instanceof class_3222 player) {
                sendToClientPlayer(player, message);
            }
        } else if (PlatHelper.isDev()) throw new AssertionError("Cant send message to clients from client side");
    }

    private class_2596<?> toVanillaPacket(Message message) {
        class_2540 buf = PacketByteBufs.create();
        message.writeToBuffer(buf);
        return ServerPlayNetworking.createS2CPacket(ID_MAP.get(message.getClass()), buf);
    }

}
