package net.mehvahdjukaar.moonlight.api.resources;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_3497;
import net.minecraft.class_6862;
import net.minecraft.class_7475;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

//wrapped tag builder for easier use
public class SimpleTagBuilder extends class_3495 {

    private final Set<String> uniqueKeys = new HashSet<>();
    private final class_2960 id;

    protected SimpleTagBuilder(class_2960 location) {
        this.id = location;
    }

    public class_2960 getId() {
        return id;
    }

    public static SimpleTagBuilder of(class_2960 location) {
        return new SimpleTagBuilder(location);
    }

    public static SimpleTagBuilder of(class_6862<?> key) {
        return new SimpleTagBuilder(key.comp_327());
    }


    public SimpleTagBuilder merge(SimpleTagBuilder other) {
        this.addAll(other.method_26782());
        return this;
    }

    public SimpleTagBuilder addAll(Collection<class_3497> entries) {
        entries.forEach(this::method_27064);
        return this;
    }

    @Override
    public class_3495 method_27064(class_3497 entry) {
        if (validateEntry(entry)) {
            return super.method_27064(entry);
        }
        return this;
    }

    public SimpleTagBuilder add(class_2960 entry) {
        super.method_26784(entry);
        return this;
    }

    public class_3495 addOptional(class_2960 elementLocation) {
        super.method_34891(elementLocation);
        return this;
    }

    //assure entry is unique
    private boolean validateEntry(class_3497 entry) {
        String string = entry.toString();
        return uniqueKeys.add(string);
    }

    //Forge stuff. we arent using it
    /*
    @Override
    public SimpleTagBuilder replace(boolean value) {
        super.replace(value);
        return this;
    }

    @Override
    public SimpleTagBuilder replace() {
        super.replace();
        return this;
    }*/

    @Override
    public SimpleTagBuilder method_26787(class_2960 pId) {
        super.method_26787(pId);
        return this;
    }

    public SimpleTagBuilder addTag(class_6862<?> tagKey) {
        return this.method_26787(tagKey.comp_327());
    }

    @Override
    public SimpleTagBuilder method_34892(class_2960 pId) {
        super.method_34892(pId);
        return this;
    }

    public SimpleTagBuilder addTag(SimpleTagBuilder otherBuilder) {
        return this.method_26787(otherBuilder.getId());
    }

    public SimpleTagBuilder addEntries(Collection<?> entries) {
        entries.forEach(e -> this.add(Utils.getID(e)));
        return this;
    }

    public SimpleTagBuilder addEntry(Object entry) {
        this.add(Utils.getID(entry));
        return this;
    }


    public JsonElement serializeToJson() {
        return class_7475.field_39269.encodeStart(JsonOps.INSTANCE, new class_7475(this.method_26782(), false))
                .getOrThrow(false, Moonlight.LOGGER::error);
    }

    public void addFromJson(JsonObject oldTag) {
        class_7475 tagfile = class_7475.field_39269.parse(new Dynamic<>(JsonOps.INSTANCE, oldTag))
                .getOrThrow(false, Moonlight.LOGGER::error);
        if (tagfile.comp_812()) {
            //TODO: figure oout how to remove stuff
        }
        tagfile.comp_811().forEach(this::method_27064);

    }
}
