package net.mehvahdjukaar.moonlight.api.resources.assets;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.stream.Collectors;

public class LangBuilder {

    private final Map<String, String> entries = new LinkedHashMap<>();

    public void addGenericEntry(String key, String translation) {
        entries.put(key, translation);
    }

    public void addEntry(class_2248 block, String translation) {
        entries.put(block.method_9539(), translation);
    }

    public <T> void addEntry(class_2378<T> reg, T entry, String translation) {
        entries.put(class_156.method_646(reg.method_30517().method_29177().method_12832(), reg.method_10221(entry)), translation);
    }

    public <T> void addSimpleEntry(class_2378<T> reg, T entry) {
        entries.put(class_156.method_646(reg.method_30517().method_29177().method_12832(), reg.method_10221(entry)),
                LangBuilder.getReadableName(reg.method_10221(entry).method_12832()));
    }

    public void addEntry(class_1792 item, String translation) {
        entries.put(item.method_7876(), translation);
    }

    public void addEntry(class_1299<?> entityType, String translation) {
        entries.put(entityType.method_5882(), translation);
    }

    public JsonElement build() {
        JsonObject json = new JsonObject();
        for (var e : entries.entrySet()) {
            json.addProperty(e.getKey(), e.getValue());
        }
        return json;
    }

    public Map<String, String> entries() {
        return entries;
    }


    //utils

    //helper to make lang strings
    public static String getReadableName(String name) {
        return Arrays.stream((name).replace(":", "_").split("_"))
                .map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    /**
     * Attempts grabbing a translated component with the given key and arguments. If none is found it will make the key itself readable
     *
     * @param key       translation key
     * @param arguments optional arguments
     * @return readable component
     */
    public static class_2561 getReadableComponent(String key, String... arguments) {
        class_2561 translated = class_2561.method_43469(key, (Object[]) arguments);
        if (translated.getString().equals(key)) {
            StringBuilder aa = new StringBuilder();
            for (String s : arguments) {
                aa.append("_").append(s);
            }
            return class_2561.method_43470(LangBuilder.getReadableName(key + aa));
        }
        return translated;
    }


    public static void addDynamicEntry(AfterLanguageLoadEvent lang,
                                       String key, BlockType type, class_1792 item) {
        String base = lang.getEntry(key);
        if (base != null) {
            String typeName = lang.getEntry(type.getTranslationKey());
            if (typeName != null) {
                lang.addEntry(item.method_7876(), String.format(base, typeName));
            } else Moonlight.LOGGER.error("Could not find translation line for typeName: {}", type.getTranslationKey());
        } else Moonlight.LOGGER.error("Could not find translation line for base: {}", key);
    }

    public static void addDynamicEntry(AfterLanguageLoadEvent lang,
                                       String key, BlockType type, class_2248 block) {
        String base = lang.getEntry(key);
        if (base != null) {
            String typeName = lang.getEntry(type.getTranslationKey());
            if (typeName != null) {
                lang.addEntry(block.method_9539(), String.format(base, typeName));
            }
        }
    }

    public static void addDynamicEntry(AfterLanguageLoadEvent lang,
                                       String key, BlockType type, class_1299<?> entityType) {
        String base = lang.getEntry(key);
        if (base != null) {
            String typeName = lang.getEntry(type.getTranslationKey());
            if (typeName != null) {
                lang.addEntry(entityType.method_5882(), String.format(base, typeName));
            }
        }
    }
}
