package net.mehvahdjukaar.moonlight.api.resources.recipe;

import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_2444;
import net.minecraft.class_7710;
import net.minecraft.class_7798;
import net.minecraft.class_7800;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public interface IRecipeTemplate<R extends class_2444> {

    <T extends BlockType> R createSimilar(T originalMat, T destinationMat, class_1792 unlockItem, @Nullable String id);

    //null if it fails to convert at least 1 ingredient
    @Nullable
    default <T extends BlockType> R createSimilar(@NotNull T originalMat, @NotNull T destinationMat, class_1792 unlockItem) {
        return createSimilar(originalMat, destinationMat, unlockItem, null);
    }

    //cast these to ICondition. Forge Only
    void addCondition(Object condition);

    List<Object> getConditions();

    static <T extends BlockType> class_1856 convertIngredients(@NotNull T originalMat, @NotNull T destinationMat, @NotNull class_1856 ing) {
        return BlockTypeSwapIngredient.create(ing, originalMat, destinationMat);
    }

    default class_7800 determineBookCategory(class_7710 recipeCategory) {
        for (var v : class_7800.values()) {
            if (recipeCategory == class_7798.method_46202(v)) return v;
        }
        return class_7800.field_40642;
    }


}
