package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.ImmutableList;
import net.mehvahdjukaar.moonlight.core.set.BlocksColorInternal;
import net.minecraft.class_156;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6885;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.stream.Stream;

public class BlocksColorAPI {

    @Nullable
    public static class_1767 getColor(class_2248 block) {
        return BlocksColorInternal.getColor(block);
    }

    @Nullable
    public static class_1767 getColor(class_1792 item) {
        return BlocksColorInternal.getColor(item);
    }

    @Nullable
    public static class_1792 getColoredItem(String key, @Nullable class_1767 color) {
        return BlocksColorInternal.getColoredItem(key, color);
    }

    @Nullable
    public static class_2248 getColoredBlock(String key, @Nullable class_1767 color) {
        return BlocksColorInternal.getColoredBlock(key, color);
    }

    public static boolean isDefaultColor(class_2248 block) {
        String key = getKey(block);
        if (key == null) return true;
        return getColoredBlock(key, null) == block;
    }

    public static boolean isDefaultColor(class_1792 item) {
        String key = getKey(item);
        if (key == null) return true;
        return getColoredItem(key, null) == item;
    }

    /**
     * Changes this block color
     * If the given color is null it will yield the default colored block, usually uncolored or white
     * Will return null if no block can be found using that color
     */
    @Nullable
    public static class_2248 changeColor(class_2248 old, @Nullable class_1767 newColor) {
        return BlocksColorInternal.changeColor(old, newColor);
    }

    /**
     * Changes this item color
     * If the given color is null it will yield the default colored item, usually uncolored or white
     * Will return null if no item can be found using that color
     */
    @Nullable
    public static class_1792 changeColor(class_1792 old, @Nullable class_1767 newColor) {
        return BlocksColorInternal.changeColor(old, newColor);
    }

    @Nullable
    public static String getKey(class_2248 block) {
        return BlocksColorInternal.getKey(block);
    }

    @Nullable
    public static String getKey(class_1792 item) {
        return BlocksColorInternal.getKey(item);
    }

    /**
     * @return all the possible keys which can be used to access the colored block groups
     */
    public static Set<String> getBlockKeys() {
        return BlocksColorInternal.getBlockKeys();
    }

    /**
     * @return all the possible keys which can be used to access the colored item groups
     */
    public static Set<String> getItemKeys() {
        return BlocksColorInternal.getItemKeys();
    }

    /**
     * This might be expensive so don't call often
     * Tag only works after world load of course
     *
     * @param key set key
     * @return a HolderSet containing oll the values of this colored group. If available a tagged set will be returned (use unwrap().getLeft())
     */
    @Nullable
    public static class_6885<class_2248> getBlockHolderSet(String key) {
        return BlocksColorInternal.getBlockHolderSet(key);
    }

    /**
     * This might be expensive so don't call often
     * Tag only works after world load of course
     *
     * @param key set key
     * @return a HolderSet containing oll the values of this colored group. If available a tagged set will be returned (use unwrap().getLeft())
     */
    @Nullable
    public static class_6885<class_1792> getItemHolderSet(String key) {
        return BlocksColorInternal.getItemHolderSet(key);
    }


    /**
     * Registers or override a color set if not already detected
     */
    public static void registerBlockColorSet(class_2960 key, EnumMap<class_1767, class_2248> blocks, @Nullable class_2248 defaultBlock) {
        BlocksColorInternal.registerBlockColorSet(key, blocks, defaultBlock);
    }

    public static void registerItemColorSet(class_2960 key, EnumMap<class_1767, class_1792> items, @Nullable class_1792 defaultItem) {
        BlocksColorInternal.registerItemColorSet(key, items, defaultItem);
    }

    public static final List<class_1767> SORTED_COLORS = class_156.method_656(() -> {
        ImmutableList.Builder<class_1767> b = ImmutableList.builder();
        var l = List.of(class_1767.field_7952, class_1767.field_7967, class_1767.field_7944, class_1767.field_7963, class_1767.field_7957,
                class_1767.field_7964, class_1767.field_7946, class_1767.field_7947, class_1767.field_7961, class_1767.field_7942,
                class_1767.field_7955, class_1767.field_7951, class_1767.field_7966, class_1767.field_7945, class_1767.field_7958, class_1767.field_7954);
        b.addAll(l);
        for (var v : class_1767.values()) {
            if (!l.contains(v)) b.add(v);
        }
        return b.build();
    });

    /**
     * Helper to register colors in order
     */
    public static <T> Stream<T> ordered(Map<class_1767, T> map) {
        return map.entrySet().stream()
                .sorted(Comparator.comparing(entry -> SORTED_COLORS.indexOf(entry.getKey())))
                .map(Map.Entry::getValue);
    }
}