package net.mehvahdjukaar.moonlight.api.set.leaves;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;
import java.util.function.Supplier;

import static net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodChildKeys.*;

public class LeavesType extends BlockType {

    public static final Codec<LeavesType> CODEC = class_2960.field_25139.flatXmap(r -> {
                LeavesType w = LeavesTypeRegistry.INSTANCE.get(r);
                if (w == null) return DataResult.error(() -> "No such leaves type: " + r);
                return DataResult.success(w);
            },
            t -> DataResult.success(t.id));

    public final class_2248 leaves;

    protected LeavesType(class_2960 id, class_2248 leaves) {
        super(id);
        this.leaves = leaves;
    }

    /// USE {@link LeavesType#getAssociatedWoodType()}
    @NotNull
    @Deprecated(forRemoval = true)
    public WoodType getWoodType() {
        var w = getAssociatedWoodType();
        if (w == null) return VanillaWoodTypes.OAK;
        return w;
    }

    @Nullable
    public WoodType getAssociatedWoodType() {
        return LeavesTypeRegistry.INSTANCE.getEquivalentWoodType(this);
    }

    @Override
    public class_1935 mainChild() {
        return leaves;
    }

    @Override
    public String getTranslationKey() {
        return "leaves_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild(LEAVES, leaves);

        WoodType equivalentWood = getAssociatedWoodType();
        class_2248 log;
        if (equivalentWood != null) {
            log = equivalentWood.log;
        }
        else {
            log = findRelatedEntry(LOG, class_7923.field_41175);

        }
        if (log != null) this.addChild(LOG, log);

        this.addChild(SAPLING, this.findRelatedEntry("sapling", class_7923.field_41175));
    }

    @Override
    public void initializeChildrenItems() {
    }

    public static class Finder extends SetFinderBuilder<LeavesType> {

        private Supplier<class_2248> leavesFinder;

        public Finder(class_2960 id) {
            super(id, LeavesTypeRegistry.INSTANCE);
            this.leavesSuffix("_leaves"); // defaults
        }

        public Finder leaves(Supplier<class_2248> planksFinder) {
            this.leavesFinder = planksFinder;
            return this;
        }

        public Finder leaves(class_2960 id) {
            return this.leaves(() -> class_7923.field_41175.method_17966(id).orElseThrow(
                    () -> new IllegalStateException("Failed to find leaves block: " + id)
            ));
        }

        public Finder leaves(String leavesName) {
            return this.leaves(Utils.idWithOptionalNamespace(leavesName, id.method_12836()));
        }

        /**
         * @param prefix include the underscore, "_" if the blockId has one
         * @param suffix include the underscore, "_" if the blockId has one
         */
        public Finder leavesAffix(String prefix, String suffix) {
            return leaves(prefix + id.method_12832() + suffix);
        }

        /**
         * @param suffix include the underscore, "_" if the blockId has one
         */
        @SuppressWarnings("UnusedReturnValue")
        public Finder leavesSuffix(String suffix) {
            return leaves(id.method_12832() + suffix);
        }

        @SuppressWarnings("UnusedReturnValue")
        /// Associated WoodType
        public Finder equivalentWood(String id) {
            LeavesTypeRegistry.INSTANCE.addLeavesToWoodMapping(this.id, new class_2960(id)); //this is ass too
            return this;
        }

        @Override
        public Optional<LeavesType> get() {
            if (PlatHelper.isModLoaded(id.method_12836())) {
                try {
                    class_2248 leaves = Preconditions.checkNotNull(leavesFinder.get(), "Manual Finder - failed to find a leaf block for {}", id);
                    var w = new LeavesType(id, leaves);
                    childNames.forEach((key, value) -> {
                        try {
                            class_1935 obj = Preconditions.checkNotNull(value.get());
                            w.addChild(key, obj);
                        } catch (Exception e) {
                            Moonlight.LOGGER.warn("Failed to find child for WoodType: {} - {}. Ignored! ERROR: {}", id, key, e.getMessage());
                        }
                    });
                    return Optional.of(w);
                } catch (Exception e) {
                    Moonlight.LOGGER.warn("Failed to find custom WoodType:  {} - ", id, e);
                }
            }
            return Optional.empty();
        }

// ─────────────────────────────────────────── Marked For Removal ────────────────────────────────────────────

        /// USE {@link LeavesTypeRegistry#addSimpleFinder(String, String)}
        @Deprecated(forRemoval = true)
        public Finder(class_2960 id, Supplier<class_2248> leaves, @Nullable Supplier<WoodType> wood) {
            this(id, leaves);
        }

        /// USE {@link LeavesTypeRegistry#addSimpleFinder(String, String)}
        @Deprecated(forRemoval = true)
        public Finder(class_2960 id, Supplier<class_2248> leaves) {
            super(id, LeavesTypeRegistry.INSTANCE);
            this.leavesFinder = leaves;
        }

        /// USE {@link LeavesTypeRegistry#addSimpleFinder(String, String)}
        @Deprecated(forRemoval = true)
        public static Finder simple(String modId, String leavesTypeName, String leavesName) {
            return new Finder(new class_2960(modId, leavesTypeName),
                    () -> class_7923.field_41175.method_10223(new class_2960(modId, leavesName)), null);
        }

        /// USE {@link LeavesTypeRegistry#addSimpleFinder(String, String)}
        @Deprecated(forRemoval = true)
        public static Finder simple(String modId, String leavesTypeName, String leavesName, String woodTypeID) {
            class_2960 leavesId = new class_2960(modId, leavesName);
            LeavesTypeRegistry.INSTANCE.addLeavesToWoodMapping(leavesId, new class_2960(woodTypeID));
            return new Finder(new class_2960(modId, leavesTypeName),
                    () -> class_7923.field_41175.method_10223(leavesId));
        }

        /**
         * USE {@link LeavesTypeRegistry#addSimpleFinder(String, String)}
         * <br>add {@link SetFinderBuilder#childBlockAffix(String, String, String)}
         * <br>OR
         * <br>add {@link SetFinderBuilder#childBlockSuffix(String, String)}
         */
        @Deprecated(forRemoval = true)
        public void addChild(String childType, String childName) {
            addChild(childType, new class_2960(id.method_12836(), childName));
        }

        /**
         * USE {@link LeavesTypeRegistry#addSimpleFinder(String, String)}
         * <br>add {@link SetFinderBuilder#childBlockAffix(String, String, String)}
         * <br>OR
         * <br>add {@link SetFinderBuilder#childBlockSuffix(String, String)}
         */
        @Deprecated(forRemoval = true)
        public void addChild(String childType, class_2960 childName) {
            childBlock(childType, childName);
        }

    }
}
