package net.mehvahdjukaar.moonlight.api.util;


import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockAccessor;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockEntityAccessor;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1278;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2601;
import net.minecraft.class_2968;
import net.minecraft.class_2969;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import net.minecraft.core.*;
import org.jetbrains.annotations.ApiStatus;

import java.util.*;
import java.util.Map.Entry;
import java.util.function.Consumer;

// point of this class is to
// dynamically register dispenser behaviors such that they can depend on tags
public class DispenserHelper {

    private static final Map<class_1792, List<class_2357>> MODDED_BEHAVIORS = new HashMap<>();
    //TODO: remove once mods have updated
    private static final Map<class_1792, List<class_2357>> STATIC_MODDED_BEHAVIORS = new HashMap<>();
    private static final Map<Priority, List<Consumer<Event>>> EVENT_LISTENERS = Map.of(
            Priority.LOW, new ArrayList<>(),
            Priority.NORMAL, new ArrayList<>(),
            Priority.HIGH, new ArrayList<>()
    );

    public static void addListener(Consumer<Event> listener, Priority priority) {
        EVENT_LISTENERS.get(priority).add(listener);
    }

    @ApiStatus.Internal
    public static void reload(class_5455 registryAccess) {
        //clear all behaviors
        Set<class_1792> failed = new HashSet<>();
        Map<class_1792, class_2357> originals = new HashMap<>();
        for (var e : MODDED_BEHAVIORS.entrySet()) {
            class_1792 item = e.getKey();
            // don't alter these as we cant override them since they are static otherwise we would lose them
            if (STATIC_MODDED_BEHAVIORS.containsKey(item)) continue;

            var expected = new ReferenceOpenHashSet<>(e.getValue());
            var current = class_2315.field_10919.get(item);
            if (current instanceof AdditionalDispenserBehavior behavior) {
                Set<AdditionalDispenserBehavior> visited = new ReferenceOpenHashSet<>();
                var original = unwrapBehavior(behavior, visited);
                if (expected.equals(visited)) {
                    originals.put(item, original);
                } else {
                    Moonlight.LOGGER.warn("Failed to unwrap original behavior for item: {}, {}, {}", item, current, expected);
                    failed.add(item);
                }
            } else if (expected.size() == 1 && expected.stream().findAny().get() == current) {
                originals.put(item, null);
            } else {
                failed.add(item);
                Moonlight.LOGGER.error("Failed to restore original behavior for item: {}, {}", item, current);
            }
        }
        //restore vanilla state
        for (var e : originals.entrySet()) {
            class_1792 item = e.getKey();
            class_2357 behavior = e.getValue();
            if (behavior != null) {
                class_2315.method_10009(item, behavior);
            } else {
                class_2315.field_10919.remove(item);
            }
        }

        //re-register all behaviors
        MODDED_BEHAVIORS.clear();

        failed.addAll(STATIC_MODDED_BEHAVIORS.keySet());

        Event event = new Event() {
            @Override
            public void register(class_1792 i, class_2357 behavior) {
                if (!failed.contains(i)) {
                    MODDED_BEHAVIORS.computeIfAbsent(i, k -> new ArrayList<>()).add(behavior);
                    class_2315.method_10009(i, behavior);
                }
            }

            @Override
            public class_5455 getRegistryAccess() {
                return registryAccess;
            }
        };
        EVENT_LISTENERS.get(Priority.LOW).forEach(l -> l.accept(event));
        EVENT_LISTENERS.get(Priority.NORMAL).forEach(l -> l.accept(event));
        EVENT_LISTENERS.get(Priority.HIGH).forEach(l -> l.accept(event));
    }


    // this only works if our behaviors are the outermost of the wrappers. This should usually be the case as most mods will run their registering code in setup and not on world load
    private static class_2357 unwrapBehavior(AdditionalDispenserBehavior behavior, Set<AdditionalDispenserBehavior> visited) {
        visited.add(behavior);
        var inner = behavior.fallback;
        if (inner instanceof AdditionalDispenserBehavior ab) {
            return unwrapBehavior(ab, visited);
        }
        return inner;
    }

    @Deprecated(forRemoval = true)
    public static void registerCustomBehavior(AdditionalDispenserBehavior behavior) {
        class_2315.method_10009(behavior.item, behavior);
        STATIC_MODDED_BEHAVIORS.computeIfAbsent(behavior.item, k -> new ArrayList<>()).add(behavior);
    }

    //block placement behavior
    @Deprecated(forRemoval = true)
    public static void registerPlaceBlockBehavior(class_1935 block) {
        class_2315.method_10009(block, PLACE_BLOCK_BEHAVIOR);
        STATIC_MODDED_BEHAVIORS.computeIfAbsent(block.method_8389(), k -> new ArrayList<>()).add(PLACE_BLOCK_BEHAVIOR);
    }

    /**
     * implement this to add your own custom behaviors
     */
    public abstract static class AdditionalDispenserBehavior implements class_2357 {

        private final class_2357 fallback;

        private final class_1792 item;

        protected AdditionalDispenserBehavior(class_1792 item) {
            this.item = item;
            fallback = DispenserBlockAccessor.getDispenserRegistry().get(item);
        }

        @Override
        public final class_1799 dispense(class_2342 source, class_1799 stack) {
            //this.setSuccessful(false);
            try {
                class_1271<class_1799> result = this.customBehavior(source, stack);
                class_1269 type = result.method_5467();
                if (type != class_1269.field_5811) {
                    boolean success = type.method_23665();
                    this.playSound(source, success);
                    this.playAnimation(source, source.method_10120().method_11654(class_2315.field_10918));
                    if (success) {
                        class_1799 resultStack = result.method_5466();
                        if (resultStack.method_7909() == stack.method_7909()) return resultStack;
                        return fillItemInDispenser(source, stack, result.method_5466());
                    }
                }
            } catch (Exception ignored) {
            }
            return fallback.dispense(source, stack);


        }

        /**
         * custom dispenser behavior that you want to implement
         *
         * @param source dispenser block
         * @param stack  stack to dispense
         * @return return ActionResult.SUCCESS / CONSUME for success, FAIL to do nothing and PASS to fall back to vanilla/previously registered behavior will be used. <br>
         * Type parameter is return item stack. If item in itemstack is different from initially provided, such itemstack will be added to dispenser, otherwise will replace existing itemstack
         */
        protected abstract class_1271<class_1799> customBehavior(class_2342 source, class_1799 stack);

        protected void playSound(class_2342 source, boolean success) {
            source.method_10207().method_20290(success ? 1000 : 1001, source.method_10122(), 0);
        }

        protected void playAnimation(class_2342 source, class_2350 direction) {
            source.method_10207().method_20290(2000, source.method_10122(), direction.method_10146());
        }

        //returns full bottle to dispenser. same function that's in IDispenserItemBehavior
        private class_1799 fillItemInDispenser(class_2342 source, class_1799 empty, class_1799 filled) {
            empty.method_7934(1);
            if (empty.method_7960()) {
                return filled.method_7972();
            } else {
                if (!mergeDispenserItem(source.method_10121(), filled)) {
                    SHOOT_BEHAVIOR.dispense(source, filled.method_7972());
                }
                return empty;
            }
        }

        //add item to dispenser and merges it if there's one already
        private boolean mergeDispenserItem(class_2601 te, class_1799 filled) {
            class_2371<class_1799> stacks = ((DispenserBlockEntityAccessor) te).getItems();
            for (int i = 0; i < te.method_5439(); ++i) {
                class_1799 s = stacks.get(i);
                if (s.method_7960() || (s.method_7909() == filled.method_7909() && s.method_7914() > s.method_7947())) {
                    filled.method_7933(s.method_7947());
                    te.method_5447(i, filled);
                    return true;
                }
            }
            return false;
        }
    }

    public static class AddItemToInventoryBehavior extends AdditionalDispenserBehavior {

        public AddItemToInventoryBehavior(class_1792 item) {
            super(item);
        }

        @Override
        protected class_1271<class_1799> customBehavior(class_2342 source, class_1799 stack) {
            //this.setSuccessful(false);
            class_3218 world = source.method_10207();
            class_2338 blockpos = source.method_10122().method_10093(source.method_10120().method_11654(class_2315.field_10918));
            class_2586 te = world.method_8321(blockpos);
            if (te instanceof class_1278 tile) {
                if (tile.method_5437(0, stack)) {
                    if (tile.method_5442()) {
                        tile.method_5447(0, stack.method_7971(1));
                    } else {
                        tile.method_5438(0).method_7933(1);
                        stack.method_7934(1);
                    }
                    return class_1271.method_22427(stack);
                }
                return class_1271.method_22431(stack);
            }
            return class_1271.method_22430(stack);
        }
    }


    public static class PlaceBlockDispenseBehavior extends class_2969 {

        @Override
        public class_1799 method_10135(class_2342 source, class_1799 stack) {
            this.method_27955(false);
            class_1792 item = stack.method_7909();
            if (item instanceof class_1747 bi) {
                class_2350 direction = source.method_10120().method_11654(class_2315.field_10918);
                class_2338 blockpos = source.method_10122().method_10093(direction);
                // Direction direction1 = source.getLevel().isEmptyBlock(blockpos.below()) ? direction : Direction.UP;
                class_2350 direction1 = direction;
                class_1269 result = bi.method_7712(new class_2968(source.method_10207(), blockpos, direction, stack, direction1));
                this.method_27955(result.method_23665());
            }
            return stack;
        }
    }

    public static class FillFluidHolderBehavior extends DispenserHelper.AdditionalDispenserBehavior {

        public FillFluidHolderBehavior(class_1792 item) {
            super(item);
        }

        @Override
        protected class_1271<class_1799> customBehavior(class_2342 source, class_1799 stack) {
            class_2338 blockpos = source.method_10122().method_10093(source.method_10120().method_11654(class_2315.field_10918));
            class_2586 te = source.method_10207().method_8321(blockpos);
            if (te instanceof ISoftFluidTankProvider tile) {
                class_1799 returnStack;
                if (tile.canInteractWithSoftFluidTank()) {

                    SoftFluidTank tank = tile.getSoftFluidTank();
                    if (!tank.isFull()) {
                        returnStack = tank.interactWithItem(stack, source.method_10207(), blockpos, false);
                        if (returnStack != null) {
                            te.method_5431();
                            return class_1271.method_22427(returnStack);
                        }
                    }
                }
                return class_1271.method_22431(stack);
            }
            return class_1271.method_22430(stack);
        }
    }

    public static final class_2347 PLACE_BLOCK_BEHAVIOR = new PlaceBlockDispenseBehavior();
    private static final class_2347 SHOOT_BEHAVIOR = new class_2347();


    public interface Event {

        void register(class_1792 i, class_2357 behavior);

        default void register(AdditionalDispenserBehavior behavior) {
            register(behavior.item, behavior);
        }

        default void registerPlaceBlock(class_1935 i) {
            register(i.method_8389(), PLACE_BLOCK_BEHAVIOR);
        }


        class_5455 getRegistryAccess();
    }


    // when wrapping order is important. Use this to set priority
    public enum Priority {
        LOW,
        NORMAL,
        HIGH
    }

}