package net.mehvahdjukaar.moonlight.api.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_1812;
import net.minecraft.class_1828;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static net.minecraft.class_1844.method_8059;
import static net.minecraft.class_1844.method_8055;

public class PotionNBTHelper {
    private static final class_5250 EMPTY = (class_2561.method_43471("effect.none")).method_27692(class_124.field_1080);

    //I need this because I'm using block entity tag, so I can't give PotionUtil methods an itemStack directly
    public static void addPotionTooltip(@Nullable class_2487 com, List<class_2561> tooltip, float durationFactor) {
        List<class_1293> list = method_8066(com);
        List<Pair<class_1320, class_1322>> list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            tooltip.add(EMPTY);
        } else {
            for (class_1293 effectInstance : list) {
                class_5250 translatable = class_2561.method_43471(effectInstance.method_5586());
                class_1291 effect = effectInstance.method_5579();
                Map<class_1320, class_1322> map = effect.method_5565();
                if (!map.isEmpty()) {
                    for (Map.Entry<class_1320, class_1322> entry : map.entrySet()) {
                        class_1322 attributemodifier = entry.getValue();
                        class_1322 modifier = new class_1322(attributemodifier.method_6185(), effect.method_5563(effectInstance.method_5578(), attributemodifier), attributemodifier.method_6182());
                        list1.add(new Pair<>(entry.getKey(), modifier));
                    }
                }

                if (effectInstance.method_5578() > 0) {
                    translatable = class_2561.method_43469("potion.withAmplifier", translatable, class_2561.method_43471("potion.potency." + effectInstance.method_5578()));
                }

                if (effectInstance.method_5584() > 20) {
                    translatable = class_2561.method_43469("potion.withDuration", translatable, class_1292.method_5577(effectInstance, durationFactor));
                }

                tooltip.add(translatable.method_27692(effect.method_18792().method_18793()));
            }
        }

        if (!list1.isEmpty()) {
            tooltip.add(class_5244.field_39003);
            tooltip.add(class_2561.method_43471("potion.whenDrank").method_27692(class_124.field_1064));

            for (Pair<class_1320, class_1322> pair : list1) {
                class_1322 modifier = pair.getSecond();
                double d0 = modifier.method_6186();
                double d1;
                if (modifier.method_6182() != class_1322.class_1323.field_6330 && modifier.method_6182() != class_1322.class_1323.field_6331) {
                    d1 = modifier.method_6186();
                } else {
                    d1 = modifier.method_6186() * 100.0D;
                }

                if (d0 > 0.0D) {
                    tooltip.add(class_2561.method_43469("attribute.modifier.plus." + modifier.method_6182().method_6191(), class_1799.field_8029.format(d1), class_2561.method_43471(pair.getFirst().method_26830())).method_27692(class_124.field_1078));
                } else if (d0 < 0.0D) {
                    d1 = d1 * -1.0D;
                    tooltip.add(class_2561.method_43469("attribute.modifier.take." + modifier.method_6182().method_6191(), class_1799.field_8029.format(d1), class_2561.method_43471(pair.getFirst().method_26830())).method_27692(class_124.field_1061));
                }
            }
        }

    }

    public static int getColorFromNBT(@Nullable class_2487 com) {
        if (com != null && com.method_10573("CustomPotionColor", 99)) {
            return com.method_10550("CustomPotionColor");
        } else {
            return method_8055(method_8066(com));
        }
    }

    public enum Type {
        REGULAR,
        SPLASH,
        LINGERING;

        static final Map<String, Type> BY_NAME = Arrays.stream(Type.values()).collect(Collectors.toMap(
                Enum::name, i -> i));

        public class_1799 getDefaultItem() {
            return (switch (this) {
                case REGULAR -> class_1802.field_8574;
                case LINGERING -> class_1802.field_8150;
                case SPLASH -> class_1802.field_8436;
            }).method_7854();
        }

        public void applyToTag(class_2487 tag){
            tag.method_10582(POTION_TYPE_KEY, this.name());
        }
    }

    public static final String POTION_TYPE_KEY = "Bottle";

    @Nullable
    public static PotionNBTHelper.Type getPotionType(class_2487 tag) {
        if (!tag.method_10545(POTION_TYPE_KEY)) return null;
        String type = tag.method_10558(POTION_TYPE_KEY);
        return Type.BY_NAME.get(type);
    }

    @Nullable
    public static PotionNBTHelper.Type getPotionType(class_1792 potionItem) {
        if (potionItem instanceof class_1828) return Type.SPLASH;
        else if (potionItem instanceof class_1803) return Type.LINGERING;
        else if (potionItem instanceof class_1812) return Type.REGULAR;
        return null;
    }

}
