package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.BaseMapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.InvPlacer;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1268;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1865;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_2985;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3448;
import net.minecraft.class_3611;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_4970.class_2251;
import net.minecraft.class_5321;
import net.minecraft.class_5328;
import net.minecraft.class_5455;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6862;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.core.*;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;


public class Utils {

    public static void swapItem(class_1657 player, class_1268 hand, class_1799 oldItem, class_1799 newItem, boolean bothSides) {
        if (!player.method_37908().field_9236 || bothSides)
            player.method_6122(hand, class_5328.method_30270(oldItem.method_7972(), player, newItem, player.method_7337()));
    }

    public static void swapItem(class_1657 player, class_1268 hand, class_1799 oldItem, class_1799 newItem) {
        swapItem(player, hand, oldItem, newItem, false);
    }

    public static void swapItemNBT(class_1657 player, class_1268 hand, class_1799 oldItem, class_1799 newItem) {
        if (!player.method_37908().field_9236)
            player.method_6122(hand, class_5328.method_30270(oldItem.method_7972(), player, newItem, false));
    }

    public static void swapItem(class_1657 player, class_1268 hand, class_1799 newItem) {
        swapItem(player, hand, player.method_5998(hand), newItem);
    }

    //TODO: add more stuff from item utils

    @Deprecated(forRemoval = true)
    public static void addStackToExisting(class_1657 player, class_1799 stack, boolean avoidEmptyHands) {
        addItemOrDrop(player, stack, avoidEmptyHands ? InvPlacer.handOrExistingOrAnyAvoidEmptyHand(class_1268.field_5808) : InvPlacer.handOrExistingOrAny(class_1268.field_5808));
    }

    /**
     * Adds an item to the player's inventory, uses the given strategy to determine where to place it
     */
    public static void addItemOrDrop(class_1657 player, class_1799 stack, InvPlacer placer) {
        class_1661 inv = player.method_31548();
        placer.or(InvPlacer.DROP).place(stack, inv, player);
    }

    public static void addItemOrDrop(class_1657 player, class_1799 stack) {
        addItemOrDrop(player, stack, InvPlacer.existingOrAny()); //default impl
    }


    //xp bottle logic
    public static int getXPinaBottle(int bottleCount, class_5819 rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; i++) xp += (3 + rand.method_43048(5) + rand.method_43048(5));
        return xp;
    }


    public static class_2960 getID(@NotNull class_2248 object) {
        return class_7923.field_41175.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1299<?> object) {
        return class_7923.field_41177.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1959 object) {
        return hackyGetRegistry(class_7924.field_41236).method_10221(object);
    }

    public static class_2960 getID(@NotNull class_8110 type) {
        return hackyGetRegistry(class_7924.field_42534).method_10221(type);
    }

    public static class_2960 getID(@NotNull class_2975<?, ?> object) {
        return hackyGetRegistry(class_7924.field_41239).method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1792 object) {
        return class_7923.field_41178.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_3611 object) {
        return class_7923.field_41173.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_2591<?> object) {
        return class_7923.field_41181.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1865<?> object) {
        return class_7923.field_41189.method_10221(object);
    }

    public static class_2960 getID(@NotNull SoftFluid object) {
        return SoftFluidRegistry.hackyGetRegistry().method_10221(object);
    }

    @Deprecated(forRemoval = true)
    public static class_2960 getID(@NotNull MapDecorationType<?, ?> object) {
        return MapDataInternal.hackyGetRegistry().method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1842 object) {
        return class_7923.field_41179.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1291 object) {
        return class_7923.field_41174.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_1761 object) {
        return class_7923.field_44687.method_10221(object);
    }

    public static class_2960 getID(@NotNull class_3448<?> object) {
        return class_7923.field_41193.method_10221(object);
    }

    public static class_2960 getID(@NotNull Object object) {
        if (object instanceof class_2248 b) return getID(b);
        if (object instanceof class_1792 b) return getID(b);
        if (object instanceof class_1299<?> b) return getID(b);
        if (object instanceof class_2591<?> b) return getID(b);
        if (object instanceof class_1959 b) return getID(b);
        if (object instanceof class_3611 b) return getID(b);
        if (object instanceof class_1865<?> b) return getID(b);
        if (object instanceof class_2975<?, ?> c) return getID(c);
        if (object instanceof class_1842 c) return getID(c);
        if (object instanceof class_1291 c) return getID(c);
        if (object instanceof Supplier<?> s) return getID(s.get());
        if (object instanceof SoftFluid s) return getID(s);
        if (object instanceof MapDecorationType<?, ?> s) return getID(s);
        if (object instanceof class_1761 t) return getID(t);
        if (object instanceof class_8110 t) return getID(t);
        if (object instanceof class_3448<?> t) return getID(t);
        throw new UnsupportedOperationException("Unsupported class type " + object.getClass() + ". Expected a registry entry for a call to Utils.getID()");
    }

    @Deprecated(forRemoval = true)
    public static <T> boolean isTagged(T entry, class_2378<T> registry, class_6862<T> tag) {
        return registry.method_47983(entry).method_40220(tag);
    }

    //very very hacky
    //attempts to grab the right registry access for the current thread, hopefully matching the logical side one
    @ApiStatus.Experimental
    public static class_5455 hackyGetRegistryAccess() {
        var s = PlatHelper.getCurrentServer();
        if (PlatHelper.getPhysicalSide().isClient()) {
            if (s != null && (s.method_18854() || !MoonlightClient.isClientThread())) return s.method_30611();
            var level = class_310.method_1551().field_1687;
            if (level != null) return level.method_30349();
            var hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
            if (hack2 != null) return hack2.get();
            throw new UnsupportedOperationException("Failed to get registry access: level was null");
        }
        if (s != null) return s.method_30611();
        var hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
        if (hack2 != null) return hack2.get();
        throw new UnsupportedOperationException("Failed to get registry access. This is a bug");
    }

    public static <T> class_2378<T> hackyGetRegistry(class_5321<class_2378<T>> registry) {
        return hackyGetRegistryAccess().method_30530(registry);
    }

    /**
     * Copies block properties without keeping stupid lambdas that could include references to the wrong blockstate properties
     */
    public static class_4970.class_2251 copyPropertySafe(class_2248 blockBehaviour) {
        var p = class_4970.class_2251.method_9630(blockBehaviour);
        class_2680 state = blockBehaviour.method_9564();
        p.method_9631(s -> state.method_26213());
        p.method_49229(class_4970.class_2250.field_10656);
        p.method_26235((blockState, blockGetter, pos, entityType) ->
                blockState.method_26206(blockGetter, pos, class_2350.field_11036) && blockState.method_26213() < 14);
        p.method_31710(blockBehaviour.method_26403());
        p.method_26249((blockState, blockGetter, blockPos) -> false);
        //TODO: this isnt safe anymore... in 1.21
        return p;
    }

    public static class_3965 rayTrace(class_1309 entity, boolean hitsFluids, float partialTicks) {
        return (class_3965) entity.method_5745(ForgeHelper.getReachDistance(entity), partialTicks, hitsFluids);
    }

    @Deprecated(forRemoval = true)
    public static class_239 rayTrace(class_1309 entity, class_1937 world, class_3959.class_3960 blockMode, class_3959.class_242 fluidMode) {
        return rayTrace(entity, world, blockMode, fluidMode, ForgeHelper.getReachDistance(entity));
    }

    // use entity.pick
    @Deprecated(forRemoval = true)
    public static class_239 rayTrace(class_1297 entity, class_1937 world, class_3959.class_3960 blockMode, class_3959.class_242 fluidMode, double range) {
        class_243 startPos = entity.method_33571();
        class_243 ray = entity.method_5828(1).method_1021(range);
        class_243 endPos = startPos.method_1019(ray);
        class_3959 context = new class_3959(startPos, endPos, blockMode, fluidMode, entity);
        return world.method_17742(context);
    }

    public static void awardAdvancement(class_3222 sp, class_2960 name) {
        awardAdvancement(sp, name, "unlock");
    }

    public static void awardAdvancement(class_3222 sp, class_2960 name, String unlockProp) {
        class_161 advancement = sp.method_5682().method_3851().method_12896(name);
        if (advancement != null) {
            class_2985 advancements = sp.method_14236();
            if (!advancements.method_12882(advancement).method_740()) {
                advancements.method_12878(advancement, unlockProp);
            }
        }
    }

    @Nullable
    public static <E extends class_2586, A extends class_2586> class_5558<A> getTicker(class_2591<A> type, class_2591<E> targetType, class_5558<? super E> ticker) {
        return targetType == type ? (class_5558<A>) ticker : null;
    }

    public static class_2680 readBlockState(class_2487 compound, @Nullable class_1937 level) {
        class_7871<class_2248> holderGetter = level != null ? level.method_45448(class_7924.field_41254) : class_7923.field_41175.method_46771();
        return class_2512.method_10681(holderGetter, compound);
    }

    public static <T extends Comparable<T>, A extends class_2769<T>> class_2680 replaceProperty(class_2680 from, class_2680 to, A property) {
        if (from.method_28498(property)) {
            return to.method_11657(property, from.method_11654(property));
        }
        return to;
    }

    //Use below
    @Deprecated(forRemoval = true)
    public static boolean mayBuild(class_1657 player, class_2338 pos) {
        return mayPerformBlockAction(player, pos, player.method_6047());
    }

    @Deprecated(forRemoval = true)
    public static boolean mayPerformBlockAction(class_1657 player, class_2338 pos) {
        return mayPerformBlockAction(player, pos, player.method_6047());
    }

    /**
     * Call this instead of player.abilities.mayBuild. Mainly used for adventure mode ege case
     * <p>
     * This is needed as vanilla handles most of its block altering actions from the item class which calls this.
     * In a Block class this should be called instead to allow adventure mode to work properly
     * <p>
     * Call when placing or modifying a block. Checks edge cases like spectator
     * Needed also in BLOCK use methods. or other places. not item i believe
     */
    public static boolean mayPerformBlockAction(class_1657 player, class_2338 pos, class_1799 stack) {
        class_1934 gameMode;
        if (player instanceof class_3222 sp) {
            gameMode = sp.field_13974.method_14257();
        } else {
            gameMode = class_310.method_1551().field_1761.method_2920();
        }
        //this only checks the adventure mode canDestroyTag tag
        boolean result = !player.method_21701(player.method_37908(), pos, gameMode);
        if (!result) {
            //also checks this because vanilla doesnt as it does not place blocks in block use method
            //also vanilla tends to allow a bunch of unpreventable adventure interactions
            if (gameMode == class_1934.field_9216 && !stack.method_7960() &&
                    stack.method_7944(
                            player.method_37908().method_30349().method_30530(class_7924.field_41254),
                            new class_2694(player.method_37908(), pos, false)
                    )) {
                return true;
            }
        }
        return result;
    }

    public static boolean isMethodImplemented(Class<?> original, Class<?> subclass, String name) {
        Method declaredMethod = findMethodWithMatchingName(subclass, name);
        Method modMethod = findMethodWithMatchingName(original, name);
        return declaredMethod != null && modMethod != null && Arrays.equals(declaredMethod.getParameterTypes(), modMethod.getParameterTypes());
    }

    private static Method findMethodWithMatchingName(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getName().equals(name)) {
                return method;
            }
        }
        return null;
    }


    @ExpectPlatform
    public static <K, V, C extends BaseMapCodec<K, V> & Codec<Map<K, V>>> C optionalMapCodec(final Codec<K> keyCodec, final Codec<V> elementCodec) {
        throw new AssertionError();
    }

    public static class_2960 idWithOptionalNamespace(String id, String namespace) {
        if (id.contains(":")) {
            return new class_2960(id);
        } else {
            return new class_2960(namespace, id);
        }
    }

    @Nullable
    public static <T> T findFirstInRegistry(class_2378<T> registry, class_2960... ids) {
        for (class_2960 r : ids) {
            var optional = registry.method_17966(r);
            if (optional.isPresent()) return optional.get();
        }
        return null;
    }

    @Nullable
    public static <T> T findFirstInRegistry(class_2378<T> registry, Iterable<class_2960> ids) {
        for (class_2960 r : ids) {
            var optional = registry.method_17966(r);
            if (optional.isPresent()) return optional.get();
        }
        return null;
    }


}