package net.mehvahdjukaar.moonlight.api.util.math;

import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class MthUtils {

    public static float[] polarToCartesian(float a, float r) {
        float x = r * class_3532.method_15362(a);
        float y = r * class_3532.method_15374(a);
        return new float[]{x, y};
    }

    public static float signedAngleDiff(double to, double from) {
        float x1 = class_3532.method_15362((float) to);
        float y1 = class_3532.method_15374((float) to);
        float x2 = class_3532.method_15362((float) from);
        float y2 = class_3532.method_15374((float) from);
        return (float) class_3532.method_15349(x1 * y1 - y1 * x2, x1 * x2 + y1 * y2);
    }

    //vector relative to a new basis
    public static class_243 changeBasisN(class_243 newBasisYVector, class_243 rot) {
        class_243 y = newBasisYVector.method_1029();
        class_243 x = new class_243(y.field_1351, y.field_1350, y.field_1352).method_1029();
        class_243 z = y.method_1036(x).method_1029();
        return changeBasis(x, y, z, rot);
    }

    public static class_243 changeBasis(class_243 newX, class_243 newY, class_243 newZ, class_243 rot) {
        return newX.method_1021(rot.field_1352).method_1019(newY.method_1021(rot.field_1351)).method_1019(newZ.method_1021(rot.field_1350));
    }

    public static class_243 getNormalFrom3DData(int direction) {
        return V3itoV3(class_2350.method_10143(direction).method_10163());
    }

    public static class_243 V3itoV3(class_2382 v) {
        return new class_243(v.method_10263(), v.method_10264(), v.method_10260());
    }

    private static double isClockWise(UnaryOperator<class_243> rot, class_2350 dir) {
        class_243 v = MthUtils.V3itoV3(dir.method_10163());
        class_243 v2 = rot.apply(v);
        return v2.method_1026(new class_243(0, 1, 0));
    }

    /**
     * Gives a vector that is equal to the one given rotated on the Y axis by a given direction
     *
     * @param dir horizontal direction
     */
    public static class_243 rotateVec3(class_243 vec, class_2350 dir) {
        double cos = 1;
        double sin = 0;
        switch (dir) {
            case field_11035 -> {
                cos = -1;
                sin = 0;
            }
            case field_11039 -> {
                cos = 0;
                sin = 1;
            }
            case field_11034 -> {
                cos = 0;
                sin = -1;
            }
            case field_11036 -> {
                return new class_243(vec.field_1352, -vec.field_1350, vec.field_1351);
            }
            case field_11033 -> {
                return new class_243(vec.field_1352, vec.field_1350, vec.field_1351);
            }
        }
        double dx = vec.field_1352 * cos + vec.field_1350 * sin;
        double dy = vec.field_1351;
        double dz = vec.field_1350 * cos - vec.field_1352 * sin;
        return new class_243(dx, dy, dz);
    }

    /**
     * Takes angles from 0 to 1
     *
     * @return mean angle
     */
    public static float averageAngles(Float... angles) {
        float x = 0, y = 0;
        for (float a : angles) {
            x += class_3532.method_15362((float) (a * Math.PI * 2));
            y += class_3532.method_15374((float) (a * Math.PI * 2));
        }
        return (float) (class_3532.method_15349(y, x) / (Math.PI * 2));
    }

    // in degrees. Opposite of Vec3.fromRotation
    public static double getPitch(class_243 vec3) {
        return -Math.toDegrees(Math.asin(vec3.field_1351));
    }

    // in degrees
    public static double getYaw(class_243 vec3) {
        return Math.toDegrees(Math.atan2(-vec3.field_1352, vec3.field_1350));
    }

    // not sure about this one tbh
    public static double getRoll(class_243 vec3) {
        return Math.toDegrees(Math.atan2(vec3.field_1351, vec3.field_1352));
    }

    public static double wrapRad(double pValue) {
        double p = Math.PI * 2;
        double d0 = pValue % p;
        if (d0 >= Math.PI) {
            d0 -= p;
        }

        if (d0 < -Math.PI) {
            d0 += p;
        }

        return d0;
    }

    public static float wrapRad(float pValue) {
        float p = (float) (Math.PI * 2);
        float d0 = pValue % p;
        if (d0 >= Math.PI) {
            d0 -= p;
        }

        if (d0 < -Math.PI) {
            d0 += p;
        }

        return d0;
    }

    /**
     * @param rand a rng
     * @param max  maximum value. Has to be >0
     * @param bias when a positive number, skew the average towards 0 (has to be from 0 to infinity).
     *             negative toward max (has to be from 0 to negative infinity). Values <= -1 are invalid.
     *             Setting it to 0 is equivalent to rand.nextFloat()*max.
     *             bias = 1 is slightly skewed towards 0 with average 0.38*max
     * @return a number between 0 and max
     * The bias parameters control how much the average is skewed toward 0 or max
     */
    public static float nextWeighted(class_5819 rand, float max, float bias) {
        float r = rand.method_43057();
        if (bias <= 0) {
            if (bias == 0) return r * max;
            //mapping 0 -1 to 0 -inf
            bias = -bias / (bias - 1);
        }
        return (max * (1 - r)) / ((bias * max * r) + 1);
    }

    /**
     * Same as above but value is included between max and min
     */
    public static float nextWeighted(class_5819 rand, float max, float bias, float min) {
        return nextWeighted(rand, max - min, bias) + min;
    }

    public static float nextWeighted(class_5819 rand, float max) {
        return nextWeighted(rand, max, 1);
    }

    /**
     * Golden ratio
     */
    public static final float PHI = (float) (1 + (Math.sqrt(5d) - 1) / 2f);

    public static <T extends BaseColor<T>> T lerpColorScale(List<T> palette, float phase) {
        if (phase >= 1) phase = phase % 1;

        int n = palette.size();
        float g = n * phase;
        int ind = (int) Math.floor(g);

        float delta = g % 1;
        T start = palette.get(ind);
        T end = palette.get((ind + 1) % n);

        return start.mixWith(end, delta);
    }

    public static boolean isWithinRectangle(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static class_265 rotateVoxelShape(class_265 source, class_2350 direction) {
        if (direction == class_2350.field_11043) return source;
        AtomicReference<class_265> newShape = new AtomicReference<>(class_259.method_1073());
        source.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            class_243 min = new class_243(minX - 0.5, minY - 0.5, minZ - 0.5);
            class_243 max = new class_243(maxX - 0.5, maxY - 0.5, maxZ - 0.5);
            class_243 v1 = MthUtils.rotateVec3(min, direction);
            class_243 v2 = MthUtils.rotateVec3(max, direction);
            class_265 s = class_259.method_31943(0.5 + Math.min(v1.field_1352, v2.field_1352), 0.5 + Math.min(v1.field_1351, v2.field_1351), 0.5 + Math.min(v1.field_1350, v2.field_1350),
                    0.5 + Math.max(v1.field_1352, v2.field_1352), 0.5 + Math.max(v1.field_1351, v2.field_1351), 0.5 + Math.max(v1.field_1350, v2.field_1350));
            newShape.set(class_259.method_1084(newShape.get(), s));
        });
        return newShape.get();
    }

    public static class_265 moveVoxelShape(class_265 source, class_243 v) {
        AtomicReference<class_265> newShape = new AtomicReference<>(class_259.method_1073());
        source.method_1089((minX, minY, minZ, maxX, maxY, maxZ) -> {
            class_265 s = class_259.method_31943(minX + v.field_1352, minY + v.field_1351, minZ + v.field_1350,
                    maxX + v.field_1352, maxY + v.field_1351, maxZ + v.field_1350);
            newShape.set(class_259.method_1084(newShape.get(), s));
        });
        return newShape.get();
    }


    public static double lambertW0(double x) {
        double maxError = 1e-6;
        if (x == -1 / Math.E) {
            return -1;
        } else if (x >= -1 / Math.E) {
            double nLog = Math.log(x);
            double nLog0 = 1;
            while (Math.abs(nLog0 - nLog) > maxError) {
                nLog0 = (x * Math.exp(-nLog)) / (1 + nLog);
                nLog = (x * Math.exp(-nLog0)) / (1 + nLog0);
            }
            // precision of the return value
            return (Math.round(1000000 * nLog) / 1000000);
        } else {
            throw new IllegalArgumentException("Not in valid range for lambertW function. x has to be greater than or equal to -1/e.");
        }
    }

    // just brute forces it with newton approximation method
    // this only uses the secondary branch of the W function
    public static double lambertW1(double x) {
        double maxError = 1e-6;
        if (x == -1 / Math.E) {
            return -1;
        } else if (x < 0 && x > -1 / Math.E) {
            double nLog = Math.log(-x);
            double nLog0 = 1;
            while (Math.abs(nLog0 - nLog) > maxError) {
                nLog0 = (nLog * nLog + x / Math.exp(nLog)) / (nLog + 1);
                nLog = (nLog0 * nLog0 + x / Math.exp(nLog0)) / (nLog0 + 1);
            }
            // precision of the return value
            return (Math.round(1000000 * nLog) / 1000000);
        } else if (x == 0) {
            return 0;
        } else {
            throw new IllegalArgumentException("Not in valid range for lambertW function. x has to be in [-1/e,0]");
        }
    }

    /**
     * Exponent function that passed by 0,0 and 1,1
     */
    private static float exp01(float t, float base) {
        return (float) (base * Math.pow(1 / base + 1, t) - base);
    }

    /**
     * An exponent function that passes by 0,0 and 1,1
     *
     * @param t     time
     * @param curve determines the "curve" of the exponent graph.
     *              0 will be a line
     *              from 0 to 1 will curve with increasing severity (edge cases with vertical line at 1, which is not a valid input)
     *              from 0 to -1 will curve downwards in the same manner
     *              This parameter essentially controls the base of the exponent
     *              0.55 happens to map to a base close to Euler's number
     */
    public static float normalizedExponent(float t, float curve) {
        if (curve == 0) return t;
        float base;
        if (curve > 0) {
            base = (float) -Math.log(curve);
        } else {
            base = (float) (Math.log(-curve) - 1);
        }
        return exp01(t, base);
    }



    // collision code


    public static class_3965 collideWithSweptAABB(class_1297 entity, class_243 movement, double maxStep) {
        class_238 aabb = entity.method_5829();
        return collideWithSweptAABB(entity.method_19538(), aabb, movement, entity.method_37908(), maxStep);
    }

    /**
     * Unlike vanilla .collide method this will have no tunnelling whatsoever and will stop the entity exactly when the first collision happens
     * It's somehow also more efficient than the vanilla method, around 2 times.
     */
    public static class_3965 collideWithSweptAABB(class_243 myPos, class_238 myBox, class_243 movement, class_1937 level, double maxStep) {
        double len = movement.method_1033();
        if (maxStep >= len) return MthUtils.collideWithSweptAABB(myPos, myBox, movement, level);

        // Divide movement into smaller steps
        class_243 stepMovement = movement.method_1029().method_1021(maxStep);
        class_243 currentPos = myPos;
        class_3965 result;

        for (double moved = 0; moved < len; moved += maxStep) {
            if (moved + maxStep > len) {
                stepMovement = movement.method_1021((len - moved) / len);
            }

            result = MthUtils.collideWithSweptAABB(currentPos, myBox, stepMovement, level);
            if (result.method_17783() != class_239.class_240.field_1333) {
                return result;
            }

            currentPos = currentPos.method_1019(stepMovement);
            myBox = myBox.method_997(stepMovement);
        }

        class_243 missPos = myPos.method_1019(movement);
        return class_3965.method_17778(missPos, class_2350.field_11036, class_2338.method_49638(missPos));
    }

    public static class_3965 collideWithSweptAABB(class_243 myPos, class_238 myBox, class_243 movement, class_1937 level) {
        class_238 encompassing = myBox.method_18804(movement);
        Set<class_2338> positions = class_2338.method_29715(encompassing)
                .map(class_2338::method_10062).collect(Collectors.toSet());

        CollisionResult earliestCollision = null;
        class_2338 hitPos = null;

        for (class_2338 pos : positions) {
            class_2680 state = level.method_8320(pos);
            if (state.method_26215()) continue;
            List<class_238> boxes = state.method_26220(level, pos).method_1090();
            for (class_238 box : boxes) {
                box = box.method_996(pos);
                CollisionResult result = sweptAABB(myBox, box, movement);
                if (result == null || result.entryTime < 0) continue;
                if (earliestCollision == null) {
                    earliestCollision = result;
                    hitPos = pos;
                } else if (result.entryTime == earliestCollision.entryTime) {
                    class_243 collidedPos = myPos.method_1019(movement.method_1021(result.entryTime));
                    if (pos.method_19770(collidedPos) < hitPos.method_19770(collidedPos)) {
                        earliestCollision = result;
                        hitPos = pos;
                    }
                } else if (result.entryTime < earliestCollision.entryTime) {
                    earliestCollision = result;
                    hitPos = pos;
                }
            }
        }


        if (earliestCollision != null && earliestCollision.entryTime < 1.0) {
            double entryTime = earliestCollision.entryTime - 0.00001f;
            movement = movement.method_1021(entryTime);
            class_243 finalPos = myPos.method_1019(movement);

            return new class_3965(finalPos, earliestCollision.direction.method_10153(), hitPos, false);
        }

        class_243 missPos = myPos.method_1019(movement);
        return class_3965.method_17778(missPos, class_2350.field_11036, class_2338.method_49638(missPos));
    }

    private static CollisionResult sweptAABB(class_238 movingBox, class_238 staticBox, class_243 movement) {
        double entryX, entryY, entryZ;
        double exitX, exitY, exitZ;
        class_2350 collisionDirection;

        if (movement.field_1352 > 0.0) {
            entryX = (staticBox.field_1323 - movingBox.field_1320) / movement.field_1352;
            exitX = (staticBox.field_1320 - movingBox.field_1323) / movement.field_1352;
        } else if (movement.field_1352 < 0.0) {
            entryX = (staticBox.field_1320 - movingBox.field_1323) / movement.field_1352;
            exitX = (staticBox.field_1323 - movingBox.field_1320) / movement.field_1352;
        } else {
            entryX = Double.NEGATIVE_INFINITY;
            exitX = Double.POSITIVE_INFINITY;
        }

        if (movement.field_1351 > 0.0) {
            entryY = (staticBox.field_1322 - movingBox.field_1325) / movement.field_1351;
            exitY = (staticBox.field_1325 - movingBox.field_1322) / movement.field_1351;
        } else if (movement.field_1351 < 0.0) {
            entryY = (staticBox.field_1325 - movingBox.field_1322) / movement.field_1351;
            exitY = (staticBox.field_1322 - movingBox.field_1325) / movement.field_1351;
        } else {
            entryY = Double.NEGATIVE_INFINITY;
            exitY = Double.POSITIVE_INFINITY;
        }

        if (movement.field_1350 > 0.0) {
            entryZ = (staticBox.field_1321 - movingBox.field_1324) / movement.field_1350;
            exitZ = (staticBox.field_1324 - movingBox.field_1321) / movement.field_1350;
        } else if (movement.field_1350 < 0.0) {
            entryZ = (staticBox.field_1324 - movingBox.field_1321) / movement.field_1350;
            exitZ = (staticBox.field_1321 - movingBox.field_1324) / movement.field_1350;
        } else {
            entryZ = Double.NEGATIVE_INFINITY;
            exitZ = Double.POSITIVE_INFINITY;
        }

        double entryTime = Math.max(Math.max(entryX, entryY), entryZ);
        double exitTime = Math.min(Math.min(exitX, exitY), exitZ);

        if (entryTime > exitTime || (entryX < 0.0 && entryY < 0.0 && entryZ < 0.0) || entryX > 1.0 || entryY > 1.0 || entryZ > 1.0) {
            return null;
        }

        if (entryX > entryY && entryX > entryZ) {
            if (movement.field_1352 > 0.0) {
                collisionDirection = class_2350.field_11034;
            } else {
                collisionDirection = class_2350.field_11039;
            }
        } else if (entryY > entryZ) {
            if (movement.field_1351 > 0.0) {
                collisionDirection = class_2350.field_11036;
            } else {
                collisionDirection = class_2350.field_11033;
            }
        } else {
            if (movement.field_1350 > 0.0) {
                collisionDirection = class_2350.field_11035;
            } else {
                collisionDirection = class_2350.field_11043;
            }
        }

        return new CollisionResult(entryTime, collisionDirection);
    }

    private record CollisionResult(double entryTime, class_2350 direction) {
    }


    //ease functions

}
