package net.mehvahdjukaar.moonlight.core.fake_player;

import com.mojang.authlib.GameProfile;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3445;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class FakeGenericPlayer extends class_1657 {

    private static final boolean HAS_CACHE = PlatHelper.getPlatform().isForge(); //fabric doesnt have world unload event

    // Map of all active fake player usernames to their entities
    // automatically gets cleaned when level is unloaded as key won't be in use anymore
    private static final WeakHashMap<class_1937, Map<GameProfile, FakeGenericPlayer>> FAKE_PLAYERS = new WeakHashMap<>();

    /**
     * Get a fake player with a given username,
     * Mods should either hold weak references to the return value, or listen for a
     * WorldEvent.Unload and kill all references to prevent worlds staying in memory.
     */
    public static FakeGenericPlayer get(class_1937 level, GameProfile username) {
        if (!HAS_CACHE) return new FakeGenericPlayer(level, username);
        return FAKE_PLAYERS.computeIfAbsent(level, l -> new HashMap<>())
                .computeIfAbsent(username, u -> new FakeGenericPlayer(level, username));
    }

    public static void unloadLevel(class_1936 level) {
        FAKE_PLAYERS.entrySet().removeIf(e -> e.getKey() == level);
    }

    public FakeGenericPlayer(class_1937 level, GameProfile gameProfile) {
        super(level, class_2338.field_10980, 0, gameProfile);
    }

    @Override
    public boolean method_7325() {
        return false;
    }

    @Override
    public boolean method_7337() {
        return false;
    }

    @Override
    public void method_7353(class_2561 chatComponent, boolean actionBar) {
    }

    @Override
    public void method_7342(class_3445 stat, int increment) {
    }

    @Override
    public boolean method_5679(class_1282 source) {
        return true;
    }

    @Override
    public boolean method_7256(class_1657 other) {
        return false;
    }

    @Override
    public void method_6078(class_1282 damageSource) {
    }

    @Override
    public void method_5773() {
    }

    public @Nullable MinecraftServer method_5682() {
        return PlatHelper.getCurrentServer();
    }
}
