package net.mehvahdjukaar.moonlight.core.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5338;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_85;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class OptionalItemPool extends class_85 {
    @Nullable
    private final class_1792 item;
    private final String res;

    OptionalItemPool(String res, int i, int j, class_5341[] lootItemConditions, class_117[] lootItemFunctions) {
        super(i, j, disableIfInvalid(res, lootItemConditions), lootItemFunctions);
        this.item = getOptional(res);
        this.res = res;
    }

    @Nullable
    private static class_1792 getOptional(String res) {
        if (res.startsWith("#")) {
            class_6862<class_1792> key = class_6862.method_40092(class_7924.field_41197, new class_2960(res.substring(1)));
            for (var v : class_7923.field_41178.method_40286(key)) return v.comp_349();
            return null;
        }
        return class_7923.field_41178.method_17966(new class_2960(res)).orElse(null);
    }

    //hacky
    private static class_5341[] disableIfInvalid(String res, class_5341[] lootItemConditions) {
        if (getOptional(res) == null) {
            List<class_5341> newCond = new ArrayList<>();
            newCond.add(class_219.method_932(0).build()); //always false
            newCond.addAll(List.of(lootItemConditions));
            return newCond.toArray(new class_5341[0]);
        }
        return lootItemConditions;
    }

    public class_5338 method_29318() {
        return  MoonlightRegistry.LAZY_ITEM.get();
    }

    public void method_433(Consumer<class_1799> stackConsumer, class_47 lootContext) {
        if (this.item != null) {
            stackConsumer.accept(new class_1799(this.item));
        } else {
            Moonlight.LOGGER.warn("Tried to add an item from a disabled OptionalLootPoolEntry");
        }
    }

    public static class_86<?> lootTableOptionalItem(String itemRes) {
        return method_434((i, j, lootItemConditions, lootItemFunctions) -> new OptionalItemPool(itemRes, i, j, lootItemConditions, lootItemFunctions));
    }

    public static class Serializer extends class_85.class_90<OptionalItemPool> {

        @Override
        public void serializeCustom(JsonObject object, OptionalItemPool context, JsonSerializationContext conditions) {
            super.method_442(object, context, conditions);
            object.addProperty("name", context.res);
        }

        protected OptionalItemPool method_443(
                JsonObject object, JsonDeserializationContext context, int weight, int quality, class_5341[] conditions, class_117[] functions
        ) {
            String item = getItemLocation(object, "name");
            return new OptionalItemPool(item, weight, quality, conditions, functions);
        }

        private static String getItemLocation(JsonObject json, String memberName) {
            if (json.has(memberName)) {
                return class_3518.method_15265(json, memberName);
            } else {
                throw new JsonSyntaxException("Missing " + memberName + ", expected to find an item");
            }
        }
    }
}