package net.mehvahdjukaar.moonlight.core.map;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.CustomDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.JsonDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.core.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.BiFunction;
import java.util.function.Supplier;

@ApiStatus.Internal
public class MapDataInternal {

    //pain
    public static final Codec<MapDecorationType<?, ?>> CODEC =
            Codec.either(CustomDecorationType.CODEC, JsonDecorationType.CODEC).xmap(
                    either -> either.map(s -> s, c -> c),
                    type -> {
                        if (type == null) {
                            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
                        }
                        if (type instanceof CustomDecorationType<?, ?> c) {
                            return Either.left(c);
                        }
                        return Either.right((JsonDecorationType) type);
                    });

    public static final Codec<MapDecorationType<?, ?>> NETWORK_CODEC =
            Codec.either(CustomDecorationType.CODEC, JsonDecorationType.NETWORK_CODEC).xmap(
                    either -> either.map(s -> s, c -> c),
                    type -> {
                        if (type == null) {
                            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
                        }
                        if (type instanceof CustomDecorationType<?, ?> c) {
                            return Either.left(c);
                        }
                        return Either.right((JsonDecorationType) type);
                    });

    //data holder
    @ApiStatus.Internal
    public static final Map<class_2960, CustomMapData.Type<?>> CUSTOM_MAP_DATA_TYPES = new LinkedHashMap<>();

    /**
     * Registers a custom data type to be stored in map data. Type will provide its onw data implementation
     **/
    public static <T extends CustomMapData<?>> CustomMapData.Type<T> registerCustomMapSavedData(CustomMapData.Type<T> type) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey(type.id())) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + type.id());
        } else {
            CUSTOM_MAP_DATA_TYPES.put(type.id(), type);
        }
        return type;
    }

    //map markers

    public static final class_5321<class_2378<MapDecorationType<?, ?>>> KEY = class_5321.method_29180(Moonlight.res("map_markers"));
    public static final class_2960 GENERIC_STRUCTURE_ID = Moonlight.res("generic_structure");
    private static final BiMap<class_2960, Supplier<CustomDecorationType<?, ?>>> CODE_TYPES_FACTORIES = HashBiMap.create();

    public static MapDecorationType<?, ?> getGenericStructure() {
        return get(GENERIC_STRUCTURE_ID);
    }

    /**
     * Call before mod setup. Register a code defined map marker type. You will still need to add a related json file
     */
    public static void registerCustomType(class_2960 id, Supplier<CustomDecorationType<?, ?>> decorationType) {
        CODE_TYPES_FACTORIES.put(id, decorationType);
    }

    //TODO: redo in 1.20.6
    //maybe rename the decoration and decortion type to MapDecorationInstance and MapDecorationType to MapDecoration and the factory to type
    public static CustomDecorationType<?, ?> createCustomType(class_2960 factoryID) {
        var factory = Objects.requireNonNull(CODE_TYPES_FACTORIES.get(factoryID),
                "No map decoration type with id: " + factoryID);
        var t = factory.get();
        //TODO: improve
        t.factoryId = factoryID;
        return t;
    }

    public static MapDecorationType<?, ?> getAssociatedType(class_6880<class_3195> structure) {
        for (var v : getValues()) {
            Optional<class_6885<class_3195>> associatedStructure = v.getAssociatedStructure();
            if (associatedStructure.isPresent() && associatedStructure.get().method_40241(structure)) {
                return v;
            }
        }
        return getGenericStructure();
    }

    @ApiStatus.Internal
    @ExpectPlatform
    public static void init() {
        throw new AssertionError();
    }

    @Deprecated
    public static class_2378<MapDecorationType<?, ?>> hackyGetRegistry() {
        return Utils.hackyGetRegistryAccess().method_30530(KEY);
    }

    public static class_2378<MapDecorationType<?, ?>> getRegistry(class_5455 registryAccess) {
        return registryAccess.method_30530(KEY);
    }

    public static Collection<MapDecorationType<?, ?>> getValues() {
        return hackyGetRegistry().method_10220().toList();
    }

    public static Set<Map.Entry<class_5321<MapDecorationType<?, ?>>, MapDecorationType<?, ?>>> getEntries() {
        return hackyGetRegistry().method_29722();
    }

    @Nullable
    public static MapDecorationType<? extends CustomMapDecoration, ?> get(String id) {
        return get(new class_2960(id));
    }

    public static MapDecorationType<?, ?> get(class_2960 id) {
        var reg = hackyGetRegistry();
        var r = reg.method_10223(id);
        if (r == null) return reg.method_10223(GENERIC_STRUCTURE_ID);
        return r;
    }

    public static Optional<MapDecorationType<?, ?>> getOptional(class_2960 id) {
        return hackyGetRegistry().method_17966(id);
    }

    public static Set<MapBlockMarker<?>> getDynamicServer(class_1657 player, int mapId, class_22 data) {
        Set<MapBlockMarker<?>> dynamic = new HashSet<>();
        for (var v : DYNAMIC_SERVER) {
            dynamic.addAll(v.apply(player, mapId, data));
        }
        return dynamic;
    }

    public static Set<MapBlockMarker<?>> getDynamicClient(int mapId, class_22 data) {
        Set<MapBlockMarker<?>> dynamic = new HashSet<>();
        for (var v : DYNAMIC_CLIENT) {
            dynamic.addAll(v.apply(mapId, data));
        }
        return dynamic;
    }


    @Nullable
    public static MapBlockMarker<?> readWorldMarker(class_2487 compound) {
        for (var id : compound.method_10541()) {
            return get(new class_2960(id)).loadMarkerFromNBT(compound.method_10562(id));
        }
        return null;
    }

    /**
     * returns a list of suitable world markers associated to a position. called by mixin code
     *
     * @param reader world
     * @param pos    world position
     * @return markers found, empty list if none found
     */
    public static List<MapBlockMarker<?>> getMarkersFromWorld(class_1922 reader, class_2338 pos) {
        List<MapBlockMarker<?>> list = new ArrayList<>();
        for (MapDecorationType<?, ?> type : getValues()) {
            MapBlockMarker<?> c = type.getWorldMarkerFromWorld(reader, pos);
            if (c != null) list.add(c);
        }
        return list;
    }

    //dynamic markers

    private static final List<TriFunction<class_1657, Integer, class_22, Set<MapBlockMarker<?>>>> DYNAMIC_SERVER = Collections.synchronizedList(new ArrayList<>());;
    private static final List<BiFunction<Integer, class_22, Set<MapBlockMarker<?>>>> DYNAMIC_CLIENT = Collections.synchronizedList(new ArrayList<>());;


    public static void addDynamicClientMarkersEvent(BiFunction<Integer, class_22, Set<MapBlockMarker<?>>> event) {
        DYNAMIC_CLIENT.add(event);
    }

    public static void addDynamicServerMarkersEvent(TriFunction<class_1657, Integer, class_22, Set<MapBlockMarker<?>>> event) {
        DYNAMIC_SERVER.add(event);
    }

}
