package net.mehvahdjukaar.moonlight.core.misc;

import com.google.common.base.Suppliers;
import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynResourceGenerator;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_3902;
import net.minecraft.class_4011;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;

// The job of this is to return an instance that first runs the early pack task, then runs the original task.
// That way the loading overlay will pick up our progress too
public class ReloadInstanceWrapper implements class_4011 {

    public static final Logger LOGGER = LogManager.getLogger("ReloadInstanceWrapper");

    public static class_4011 wrap(Supplier<class_4011> factory, class_3264 type, class_3300 manager, Executor backgroundExecutor) {
        return new ReloadInstanceWrapper(factory, type, manager, backgroundExecutor);
    }

    public static void executeEarlyReloadBlocking(class_3264 type, class_3300 manager, IProgressTracker progressTracker) {
        DynResourceGenerator.clearBeforeReload(type);
        MoonlightEventsHelper.postEvent(new EarlyPackReloadEvent(List.of(), manager, type, progressTracker), EarlyPackReloadEvent.class);
    }

    private final Supplier<class_4011> lazyInstance;
    private final CompletableFuture<class_3902> beforeTask;
    private final IProgressTracker.Tree progressTracker;

    public ReloadInstanceWrapper(Supplier<class_4011> factory,
                                 class_3264 type, class_3300 manager, Executor executor) {
        this.progressTracker = IProgressTracker.createTree(1);
        this.lazyInstance = Suppliers.memoize(factory::get);
        this.beforeTask = CompletableFuture.supplyAsync(() -> {
            executeEarlyReloadBlocking(type, manager, progressTracker);
            return class_3902.field_17274;
        }, executor);


    }

    @Nullable
    private class_4011 allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause() {
        if (beforeTask.isDone() && !beforeTask.isCompletedExceptionally()) {
            return lazyInstance.get();
        }
        return null;
    }

    @Override
    public CompletableFuture<?> method_18364() {
        return beforeTask.thenCompose(unused -> {
            class_4011 actual = allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause();
            return actual.method_18364();
        });
    }

    @Override
    public float method_18229() {
        float maxAmount = class_3532.method_15363(0.2f, 0, 0.5f);
        float progress = progressTracker.getProgress() * maxAmount;
        if (!beforeTask.isDone()) {
            return progress;
        }
        class_4011 actual = allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause();
        if (actual != null) {
            return progress + actual.method_18229() * (1 - maxAmount);
        }
        return 1;
    }


    @Override
    public void method_18849() {
        if (!beforeTask.isDone()) {
            return;
        }
        if (beforeTask.isCompletedExceptionally()) {
            //beforeTask.join(); // This will throw the exception
        }
        class_4011 actual = allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause();
        if (actual != null) {
            actual.method_18849();
        }
    }

}
