package net.mehvahdjukaar.moonlight.core.misc;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1646;
import net.minecraft.class_3988;
import net.minecraft.class_4095;
import net.minecraft.class_4170;
import net.minecraft.class_7924;
import java.util.function.Supplier;

public class VillagerAIInternal {


    public static void init() {
    }

    //schedule to which all the tasks are registered to
    public static final Supplier<class_4170> CUSTOM_VILLAGER_SCHEDULE =
            RegHelper.register(Moonlight.res("custom_villager_schedule"), class_4170::new, class_7924.field_41220);


    //called by mixin. Do not call
    public static void onRegisterBrainGoals(class_4095<class_1646> brain, class_3988 villager) {
        if (villager instanceof class_1646 v) {
            var event = createEvent(brain, v);
            MoonlightEventsHelper.postEvent(event, IVillagerBrainEvent.class);
            //don't waste time if it doesn't have a custom schedule
            var internal = event.getInternal();
            if (internal.hasCustomSchedule()) {
                //finalize schedule
                brain.method_18884(internal.buildFinalizedSchedule());
                brain.method_18871(villager.method_37908().method_8532(),villager.method_37908().method_8510());
            }
        }
    }

    @ExpectPlatform
    public static IVillagerBrainEvent createEvent(class_4095<class_1646> brain, class_1646 villager){
        throw new AssertionError();
    }
}
