package net.mehvahdjukaar.moonlight.core.mixins;

import ;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_2350;
import net.minecraft.class_3965;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

/**
 * This stuff attempts to fix an issue where you can totally create a BlockPlaceContext with null player
 * as both it and its parent class allows it. Heck even getPlayer is nullable
 * However all the getDirection methods dont check for it causing crashes if mods happen to call it with these on thix context
 */
@Mixin(class_1750.class)
public abstract class FixBlockPlaceContextMixin extends class_1838 {

    @Shadow
    protected boolean replaceClicked;

    protected FixBlockPlaceContextMixin(class_1657 player, class_1268 interactionHand, class_3965 blockHitResult) {
        super(player, interactionHand, blockHitResult);
    }

    @Inject(method = "getNearestLookingDirection", at = @At("HEAD"), cancellable = true)
    public void fixNotAccountingForNullPlayer1(CallbackInfoReturnable<class_2350> cir) {
        if (this.method_8036() == null) cir.setReturnValue(class_2350.field_11043);
    }

    @Inject(method = "getNearestLookingVerticalDirection", at = @At("HEAD"), cancellable = true)
    public void fixNotAccountingForNullPlayer2(CallbackInfoReturnable<class_2350> cir) {
        if (this.method_8036() == null) cir.setReturnValue(class_2350.field_11036);
    }

    @Inject(method = "getNearestLookingDirections", at = @At("HEAD"), cancellable = true)
    public void fixNotAccountingForNullPlayer3(CallbackInfoReturnable<class_2350[]> cir) {
        if (this.method_8036() == null) {
            var directions = class_2350.values();
            if (this.replaceClicked) {
                cir.setReturnValue(directions);
            } else {
                class_2350 direction = this.method_8038();
                int i = 0;

                while (i < directions.length && directions[i] != direction.method_10153()) {
                    ++i;
                }

                if (i > 0) {
                    System.arraycopy(directions, 0, directions, 1, i);
                    directions[0] = direction.method_10153();
                }

                cir.setReturnValue(directions);
            }
        }
    }
}
