package net.mehvahdjukaar.moonlight.core.mixins.fabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.fabric.ResourceConditionsBridge;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_4309;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Iterator;
import java.util.Map;

@Mixin(class_4080.class)
public abstract class ConditionsHackMixin {

    //TODO: refactor in 1.20 and mixin into forge side instead. Then use fabric stuff everywhere directly
    //literally copies what fabric does
    @Inject(at = @At("HEAD"), method = "method_18790")
    private void applyResourceConditions(class_3300 resourceManager, class_3695 profiler, Object object, CallbackInfo ci) {
        if ((Object) this instanceof class_4309) {
            Iterator<Map.Entry<class_2960, JsonElement>> it = ((Map<class_2960, JsonElement>) object).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<class_2960, JsonElement> entry = it.next();
                JsonElement resourceData = entry.getValue();
                if (resourceData == null) {
                    continue;
                }
                if (resourceData.isJsonObject()) {
                    JsonObject obj = resourceData.getAsJsonObject();
                    if (!ResourceConditionsBridge.matchesForgeCondition(obj)) {
                        it.remove();
                    }
                }
            }
        }
    }
}
