package net.mehvahdjukaar.moonlight.core.mixins.fabric;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.fabric.ClientHelperImpl;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_5912;
import net.minecraft.class_5944;
import net.minecraft.class_757;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;
import java.util.function.Consumer;

@Mixin(class_757.class)
public abstract class GameRendererMixin {

    @Inject(method = "reloadShaders", at = @At(value = "INVOKE",
            ordinal = 56,
            shift = At.Shift.AFTER,
            target = "Ljava/util/List;add(Ljava/lang/Object;)Z"))
    public void moonlight$registerShaders(class_5912 resourceProvider, CallbackInfo ci,
                                          @Local(ordinal = 1) List<Pair<class_5944, Consumer<class_5944>>> list) {
        ClientHelper.ShaderEvent event = (id, vertexFormat, setter) -> {
            try {
                class_5944 shader = new class_5944(resourceProvider, id.toString()
                        .replace(":", "moonlight_marker"), vertexFormat);
                list.add(Pair.of(shader, setter));
            } catch (Exception e) {
                Moonlight.LOGGER.error("Failed to load shader: {}", id, e);
                if (PlatHelper.isDev()) throw new RuntimeException(e);
            }
        };
        ClientHelperImpl.SHADER_REGISTRATIONS.forEach(l -> l.accept(event));
        ClientHelperImpl.SHADER_REGISTRATIONS.clear();

    }
}
