package net.mehvahdjukaar.moonlight.core.mixins.fabric;

import net.mehvahdjukaar.moonlight.api.item.IItemDecoratorRenderer;
import net.mehvahdjukaar.moonlight.api.platform.fabric.ClientHelperImpl;
import net.minecraft.class_1799;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_332.class)
public abstract class ItemRendererMixin {

    @Inject(
            method = "renderItemDecorations(Lnet/minecraft/client/gui/Font;Lnet/minecraft/world/item/ItemStack;IILjava/lang/String;)V",
            at = @At(value = "RETURN")
    )
    private void renderInGui(class_327 font, class_1799 stack, int xPosition, int yPosition, String string, CallbackInfo ci) {
        if (!stack.method_7960()) {
            var decorator = ClientHelperImpl.ITEM_DECORATORS.get(stack.method_7909());
            if (decorator != null) {
                decorator.render((class_332) (Object) this, font, stack, xPosition, yPosition);
            }
        }
    }
}