package net.mehvahdjukaar.moonlight.core.mixins.fabric;

import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.mehvahdjukaar.moonlight.api.client.ModFluidRenderProperties;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

//implementing is enough. they have same signature
@Mixin(ModFluidRenderProperties.class)
public abstract class SelfModFluidRendererPropertiesMixin implements FluidRenderHandler {

    @Unique
    protected final class_1058[] sprites = new class_1058[3];

    @Shadow
    public abstract int getTintColor(class_3610 state, class_1920 getter, class_2338 pos);

    @Shadow
    @NotNull
    public abstract class_2960 getStillTexture();

    @Shadow
    @NotNull
    public abstract class_2960 getFlowingTexture();

    @Shadow
    @Nullable
    public abstract class_2960 getOverlayTexture();

    @Override
    public int getFluidColor(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
        return getTintColor(state, view, pos);
    }


    @Override
    public void reloadTextures(class_1059 textureAtlas) {
        sprites[0] = textureAtlas.method_4608(getStillTexture());
        sprites[1] = textureAtlas.method_4608(getFlowingTexture());

        var overlayTexture = this.getOverlayTexture();
        if (overlayTexture != null) {
            sprites[2] = textureAtlas.method_4608(overlayTexture);
        }
    }

    @Override
    public class_1058[] getFluidSprites(@Nullable class_1920 view, @Nullable class_2338 pos, class_3610 state) {
        return sprites;
    }
}
