package net.mehvahdjukaar.moonlight.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.resources.recipe.IRecipeTemplate;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2447;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.concurrent.atomic.AtomicReference;

public class ShapedRecipeTemplate implements IRecipeTemplate<class_2447.class_2448> {

    private final List<Object> conditions = new ArrayList<>();

    public final class_1792 result;
    public final int count;
    public final String group;
    public final List<String> pattern;
    public final Map<Character, class_1856> keys;
    public final class_7710 category;

    public ShapedRecipeTemplate(JsonObject json) {
        JsonObject result = json.getAsJsonObject("result");
        class_2960 item = new class_2960(result.get("item").getAsString());
        int count = 1;
        var c = result.get("count");
        if (c != null) count = c.getAsInt();

        this.result = class_7923.field_41178.method_10223(item);
        this.count = count;
        this.category = class_7710.field_40252.method_47920(class_3518.method_15253(json, "category", null), class_7710.field_40251);
        var g = json.get("group");
        this.group = g == null ? "" : g.getAsString();

        List<String> patternList = new ArrayList<>();
        JsonArray patterns = json.getAsJsonArray("pattern");
        patterns.forEach(p -> patternList.add(p.getAsString()));

        Map<Character, class_1856> keyMap = new HashMap<>();
        JsonObject keys = json.getAsJsonObject("key");
        keys.entrySet().forEach((e) -> keyMap.put(e.getKey().charAt(0), class_1856.method_52177(e.getValue())));

        this.keys = keyMap;
        this.pattern = patternList;
    }

    public <T extends BlockType> class_2447.class_2448 createSimilar(@NotNull T originalMat, @NotNull T destinationMat, class_1792 unlockItem, String id) {
        class_1935 newRes = BlockType.changeItemType(this.result, originalMat, destinationMat);
        if (newRes == null) {
            throw new UnsupportedOperationException(String.format("Could not convert output item %s from type %s to %s",
                    this.result, originalMat, destinationMat));
        }

        class_2447 builder = new class_2447(determineBookCategory(this.category),
                newRes, this.count);

        boolean atLeastOneChanged = false;
        for (var e : this.keys.entrySet()) {
            class_1856 ing = e.getValue();
            class_1856 newIng = IRecipeTemplate.convertIngredients(originalMat, destinationMat, ing);
            if (newIng != null) {
                atLeastOneChanged = true;
            } else newIng = ing;

            builder.method_10428(e.getKey(), newIng);
        }
        //if recipe fails
        if (!atLeastOneChanged) return null;

        this.pattern.forEach(builder::method_10439);
        builder.method_10435(group);
        builder.method_10429("has_item", class_2066.class_2068.method_8959(unlockItem));

        AtomicReference<class_2447.class_2448> newRecipe = new AtomicReference<>();

        if (id == null) {
            builder.method_10431(r -> newRecipe.set((class_2447.class_2448) r));
        } else {
            builder.method_36443(r -> newRecipe.set((class_2447.class_2448) r), id);
        }
        return newRecipe.get();
    }

    @Override
    public List<Object> getConditions() {
        return conditions;
    }

    @Override
    public void addCondition(Object condition) {
        this.conditions.add(condition);
    }

    public boolean shouldBeShapeless() {
        return this.pattern.size() == 1 && this.pattern.get(0).length() == 1;
    }

    public ShapelessRecipeTemplate toShapeless() {
        return new ShapelessRecipeTemplate(this);
    }
}