package net.mehvahdjukaar.moonlight.api.block;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1778;
import net.minecraft.class_1786;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1821;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8046;
import net.minecraft.class_8162;
import net.minecraft.class_9062;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.Nullable;

/**
 * Author: MehVahdJukaar
 * Used for blocks that can be lit up. Implement for best compatibility. Do not modify
 */
public interface ILightable {

    class_6862<class_1792> FLINT_AND_STEELS = class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("c", "tools/igniter"));

    boolean isLitUp(class_2680 state, class_1922 level, class_2338 pos);

    default void setLitUp(class_2680 state, class_1936 world, class_2338 pos, boolean lit) {
        setLitUp(state, world, pos, null, lit);
    }

    void setLitUp(class_2680 state, class_1936 world, class_2338 pos, @Nullable class_1297 entity,  boolean lit);


    @Deprecated(forRemoval = true)
    default boolean lightUp(@Nullable class_1297 player, class_2680 state, class_2338 pos, class_1936 world, FireSoundType fireSourceType) {
        return tryLightUp(player, state, pos, world, fireSourceType);
    }

    default boolean tryLightUp(@Nullable class_1297 player, class_2680 state, class_2338 pos, class_1936 world, FireSoundType fireSourceType) {
        if (!isLitUp(state, world, pos)) {
            if (!world.method_8608()) {
                this.setLitUp(state, world, pos, true);
                playLightUpSound(world, pos, fireSourceType);
            }
            world.method_33596(player, class_5712.field_28733, pos);
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval = true)
    default boolean extinguish(@Nullable class_1297 player, class_2680 state, class_2338 pos, class_1936 world) {
        return tryExtinguish(player, state, pos, world);
    }

    default boolean tryExtinguish(@Nullable class_1297 player, class_2680 state, class_2338 pos, class_1936 world) {
        if (this.isLitUp(state, world, pos)) {
            if (!world.method_8608()) {
                playExtinguishSound(world, pos);
                this.setLitUp(state, world, pos, false);
            } else {
                spawnSmokeParticles(state, pos, world);
            }
            world.method_33596(player, class_5712.field_28733, pos);
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval = true)
    default boolean interactWithEntity(class_1937 level, class_2680 state, class_1297 projectile, class_2338 pos) {
        return lightableInteractWithEntity(level, state, projectile, pos);
    }

    default boolean lightableInteractWithEntity(class_1937 level, class_2680 state, class_1297 projectile, class_2338 pos) {
        if (projectile.method_5809()) {
            class_1297 owner = projectile instanceof class_8046 te ? te.method_24921() : null;
            if (owner == null || owner instanceof class_1657 || PlatHelper.isMobGriefingOn(level, owner)) {
                return tryLightUp(projectile, state, pos, level, FireSoundType.FLAMING_ARROW);
            }
        }
        // Now handled by mixin since it needs bigger radius
        /*
        else if (projectile instanceof ThrownPotion potion &&
                potion.getItem().getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).is(Potions.WATER)) {
            Entity entity = projectile.getOwner();
            boolean flag = entity == null || entity instanceof Player || PlatHelper.isMobGriefingOn(level, entity);
            return flag && extinguish(projectile, state, pos, level);
        }*/
        return false;
    }

    @Deprecated(forRemoval = true)
    default class_9062 interactWithPlayerItem(class_2680 state, class_1937 level, class_2338 pos, class_1657 player,
                                                         class_1268 hand, class_1799 stack) {
        return lightableInteractWithPlayerItem(state, level, pos, player, hand, stack);
    }

    //call on use
    default class_9062 lightableInteractWithPlayerItem(class_2680 state, class_1937 level, class_2338 pos, class_1657 player,
                                                         class_1268 hand, class_1799 stack) {
        if (Utils.mayPerformBlockAction(player, pos, stack)) {
            if (!this.isLitUp(state, level, pos)) {
                class_1792 item = stack.method_7909();
                if (item instanceof class_1786 || stack.method_31573(FLINT_AND_STEELS)) {
                    if (tryLightUp(player, state, pos, level, FireSoundType.FLINT_AND_STEEL)) {
                        stack.method_7970(1, player, class_1309.method_56079(hand));
                        return class_9062.method_55644(level.field_9236);
                    }
                } else if (item instanceof class_1778) {
                    if (tryLightUp(player, state, pos, level, FireSoundType.FIRE_CHANGE)) {
                        stack.method_57008(1, player);
                        return class_9062.method_55644(level.field_9236);
                    }
                }
            } else if (this.canBeExtinguishedBy(stack)) {
                if (tryExtinguish(player, state, pos, level)) {
                    if (!(stack.method_7909() instanceof class_8162)) {
                        return class_9062.method_55644(level.field_9236);
                    }
                }
            }
        }
        return class_9062.field_47731;
    }

    default boolean canBeExtinguishedBy(class_1799 item) {
        return item.method_7909() instanceof class_1821 || item.method_7909() instanceof class_8162;
    }

    default void playLightUpSound(class_1936 world, class_2338 pos, FireSoundType type) {
        type.play(world, pos);
    }

    default void playExtinguishSound(class_1936 world, class_2338 pos) {
        world.method_8396(null, pos, class_3417.field_15222, class_3419.field_15245, 0.5F, 1.5F);
    }

    default void spawnSmokeParticles(class_2680 state, class_2338 pos, class_1936 world) {
        class_5819 random = world.method_8409();
        for (int i = 0; i < 10; ++i) {
            //particle offset
            world.method_8406(class_2398.field_11251, pos.method_10263() + 0.25f + random.method_43057() * 0.5f, pos.method_10264() + 0.35f + random.method_43057() * 0.5f, pos.method_10260() + 0.25f + random.method_43057() * 0.5f, 0, 0.005, 0);
        }
    }

    @FunctionalInterface
    interface FireSoundType {
        FireSoundType FLINT_AND_STEEL = (level, pos) ->
                level.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0F, level.method_8409().method_43057() * 0.4F + 0.8F);

        FireSoundType FIRE_CHANGE = (level, pos) ->
                level.method_8396(null, pos, class_3417.field_15013, class_3419.field_15245, 1.0F, (level.method_8409().method_43057() - level.method_8409().method_43057()) * 0.2F + 1.0F);

        FireSoundType FLAMING_ARROW = (level, pos) ->
                level.method_8396(null, pos, class_3417.field_15013, class_3419.field_15245, 0.5F, 1.4F);

        void play(class_1936 level, class_2338 pos);

    }

}
