package net.mehvahdjukaar.moonlight.api.block;

import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;

public interface IOwnerProtected {

    @Nullable
    UUID getOwner();

    void setOwner(@Nullable UUID owner);

    default void saveOwner(class_2487 tag){
        UUID owner = this.getOwner();
        if(owner != null){
            tag.method_25927("Owner", owner);
        }
    }

    default void loadOwner(class_2487 tag) {
        if (tag.method_10545("Owner")){
            this.setOwner(tag.method_25926("Owner"));
        }
    }

    default boolean isOwnedBy(class_1657 player) {
        UUID id = this.getOwner();
        return (id != null && id.equals(player.method_5667()));
    }

    default boolean isPublic() {
        return this.getOwner() == null;
    }

    default boolean isAccessibleBy(class_1657 player){
        return this.isPublic() || this.isOwnedBy(player);
    }

    default boolean isNotOwnedBy(class_1657 player) {
        UUID id = this.getOwner();
        return (id != null && !id.equals(player.method_5667()));
    }

}
