package net.mehvahdjukaar.moonlight.api.client.texture_renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_6364;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class FrameBufferBackedDynamicTexture extends class_1044 {

    //runs when texture is initialized and populates it. Runs each tick if its tickable
    protected final Consumer<FrameBufferBackedDynamicTexture> drawingFunction;
    private boolean initialized = false;

    //thing where it renders stuff on
    private class_276 frameBuffer;

    private final int width;
    private final int height;
    private final class_2960 resourceLocation;

    //cpu side of the texture. used to dynamically edit it
    @Nullable
    private class_1011 cpuImage;

    public FrameBufferBackedDynamicTexture(class_2960 resourceLocation, int width, int height,
                                           @Nullable Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction) {
        this.width = width;
        this.height = height;
        this.resourceLocation = resourceLocation;
        this.drawingFunction = textureDrawingFunction;
    }

    public FrameBufferBackedDynamicTexture(class_2960 resourceLocation, int size,
                                           @Nullable Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction) {
        this(resourceLocation, size, size, textureDrawingFunction);
    }

    @ApiStatus.Internal
    public void initialize() {
        this.initialized = true;
        //this.bind(); // assign gpu texture id
        //register this texture. Call at the right time or stuff will get messed up
        class_310.method_1551().method_1531().method_4616(resourceLocation, this);
        redraw();
    }

    /**
     * Force redraw using provided render function. You can also redraw manually
     */
    public void redraw() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> {
                method_23207();
                if (drawingFunction != null) {
                    drawingFunction.accept(this);
                }
            });
        } else {
            method_23207();
            if (drawingFunction != null) {
                drawingFunction.accept(this);
            }
        }
    }

    /**
     * Call to register this texture
     */
    public boolean isInitialized() {
        return initialized;
    }

    @Override
    public void method_4625(class_3300 manager) {
    }

    public class_276 getFrameBuffer() {
        //initAfterSetup the frame buffer (do not touch, magic code)
        if (this.frameBuffer == null) {
            this.frameBuffer = new class_6364(width, height);
            this.field_5204 = this.frameBuffer.method_30277(); // just in case
        }
        return this.frameBuffer;
    }

    //sets current frame buffer to this. Further, render calls will draw here
    public void bindWrite() {
        getFrameBuffer().method_1235(true);
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public class_2960 getTextureLocation() {
        return resourceLocation;
    }

    @Override
    public int method_4624() {
        return this.getFrameBuffer().method_30277();
    }

    @Override
    public void method_4528() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::clearGlId0);
        } else {
            this.clearGlId0();
        }
    }

    private void clearGlId0() {
        if (this.frameBuffer != null) {
            this.frameBuffer.method_1238();
            this.frameBuffer = null;
        }
        this.field_5204 = -1;
    }

    @Override
    public void close() {
        //releases texture id
        this.method_4528();
        //closes native image and texture
        if (this.cpuImage != null) {
            this.cpuImage.close();
            this.cpuImage = null;
        }
        //destroy render buffer
        //dont do this, it causes many issues
        // if (this.initialized) Minecraft.getInstance().getTextureManager().release(resourceLocation);
    }

    public class_1011 getPixels() {
        if (this.cpuImage == null) {
            this.cpuImage = new class_1011(width, height, false);
        }
        return cpuImage;
    }

    /**
     * Downloads the GPU texture to CPU for edit
     */
    public void download() {
        this.method_23207();
        getPixels().method_4327(0, false);
        //cpuImage.flipY();
    }

    /**
     * Uploads the image to GPU and closes its CPU side one
     */
    public void upload() {
        if (this.cpuImage != null) {
            this.method_23207();
            this.cpuImage.method_4301(0, 0, 0, false);
            this.cpuImage.close();
            this.cpuImage = null;
        } else {
            Moonlight.LOGGER.warn("Trying to upload disposed texture {}", this.method_4624());
        }
    }

    public List<Path> saveTextureToFile(Path texturesDir) throws IOException {
        return saveTextureToFile(texturesDir, this.resourceLocation.method_12832().replace("/", "_"));
    }

    public List<Path> saveTextureToFile(Path texturesDir, String name) throws IOException {
        this.method_23207();

        GL11.glPixelStorei(GL11.GL_PACK_ALIGNMENT, 1);
        GL11.glPixelStorei(GL11.GL_UNPACK_ALIGNMENT, 1);

        List<Path> textureFiles = new ArrayList<>();

        int width = GL11.glGetTexLevelParameteri(GL11.GL_TEXTURE_2D, 0, GL11.GL_TEXTURE_WIDTH);
        int height = GL11.glGetTexLevelParameteri(GL11.GL_TEXTURE_2D, 0, GL11.GL_TEXTURE_HEIGHT);
        int size = width * height;
        if (size == 0) {
            return List.of();
        }

        BufferedImage bufferedimage = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
        Path output = texturesDir.resolve(name + ".png");
        IntBuffer buffer = BufferUtils.createIntBuffer(size);
        int[] data = new int[size];

        GL11.glGetTexImage(GL11.GL_TEXTURE_2D, 0, GL12.GL_BGRA, GL12.GL_UNSIGNED_INT_8_8_8_8_REV, buffer);
        buffer.get(data);
        bufferedimage.setRGB(0, 0, width, height, data, 0, width);

        ImageIO.write(bufferedimage, "png", output.toFile());
        //   WoodGood.LOGGER.info("Exported png to: {}", output.toString());
        textureFiles.add(output);

        return textureFiles;
    }
}