package net.mehvahdjukaar.moonlight.api.client.util;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_746;

public class LOD {
    public static final LOD MAX = new LOD(0);

    private final double distSq;

    private LOD(double distance) {
        this.distSq = distance;
    }

    public LOD(class_4184 camera, class_2338 pos) {
        this(camera.method_19326(), pos);
    }

    public LOD(class_243 cameraPos, class_2338 pos) {
        this(isScoping() ? 1 : class_243.method_24953(pos).method_1025(cameraPos));
    }

    public static boolean isScoping(){
        class_310 minecraft = class_310.method_1551();
        class_746 localplayer = minecraft.field_1724;
        return localplayer != null && minecraft.field_1690.method_31044().method_31034() && localplayer.method_31550();
    }

    public boolean isVeryNear() {
        return this.distSq < VERY_NEAR_DIST;
    }

    public boolean isNear() {
        return this.distSq < NEAR_DIST;
    }

    public boolean isNearMed() {
        return this.distSq < NEAR_MED_DIST;
    }

    public boolean isMedium() {
        return this.distSq < MEDIUM_DIST;
    }

    public boolean isFar() {
        return this.distSq < FAR_DIST;
    }


    //all squared
    public static final int BUFFER = 2 * 2;
    public static final int VERY_NEAR_DIST = 16 * 16;
    public static final int NEAR_DIST = 32 * 32;
    public static final int NEAR_MED_DIST = 48 * 48;
    public static final int MEDIUM_DIST = 64 * 64;
    public static final int FAR_DIST = 96 * 96;

    //TODO: refactor and make member methods
    @Deprecated(forRemoval = true)
    public static boolean isOutOfFocus(class_243 cameraPos, class_2338 pos, float blockYaw) {
        return isOutOfFocus(cameraPos, pos, blockYaw, 0, class_2350.field_11036, 0);
    }

    @Deprecated(forRemoval = true)
    public static boolean isOutOfFocus(class_243 cameraPos, class_2338 pos, float blockYaw, float degMargin, class_2350 dir, float offset) {
        float relAngle = getRelativeAngle(cameraPos, pos, dir, offset);
        return isOutOfFocus(relAngle, blockYaw, degMargin);
    }

    @Deprecated(forRemoval = true)
    public static boolean isOutOfFocus(float relativeAngle, float blockYaw, float degMargin) {
        return (class_3532.method_15381(relativeAngle, blockYaw - 90) > -degMargin);
    }

    public static float getRelativeAngle(class_243 cameraPos, class_2338 pos) {
        return getRelativeAngle(cameraPos, pos, class_2350.field_11036, 0);
    }

    public static float getRelativeAngle(class_243 cameraPos, class_2338 pos, class_2350 dir, float offset) {
        return (float) (class_3532.method_15349(
                offset * dir.method_10148() + cameraPos.field_1352 - (pos.method_10263() + 0.5f),
                offset * dir.method_10165() + cameraPos.field_1350 - (pos.method_10260() + 0.5f)) * 180 / Math.PI);
    }

}
