package net.mehvahdjukaar.moonlight.api.fluids;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_4174;
import net.minecraft.class_7923;
import net.minecraft.class_9298;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.function.Consumer;

public class FoodProvider {

    private static final Codec<FoodProvider> CODEC_FULL = RecordCodecBuilder.create((instance) -> instance.group(
            Utils.optionalRegistryCodec(class_7923.field_41178, class_1802.field_8162).fieldOf("item").forGetter(f -> f.foodItem),
            SoftFluid.Capacity.INT_CODEC.optionalFieldOf("divider", 1).forGetter(f -> f.divider)
    ).apply(instance, FoodProvider::create));

    private static final Codec<FoodProvider> CODEC_SIMPLE = Utils.optionalRegistryCodec(class_7923.field_41178, class_1802.field_8162)
            .xmap(a -> new FoodProvider(a, 1), FoodProvider::getFoodItem);

    public static final Codec<FoodProvider> CODEC = Codec.withAlternative(CODEC_FULL, CODEC_SIMPLE);

    public static final FoodProvider EMPTY = new FoodProvider(class_1802.field_8162, 1);

    protected final class_1792 foodItem;
    protected final int divider;

    private FoodProvider(class_1792 food, int divider) {
        this.foodItem = food;
        this.divider = divider;
    }

    public class_1792 getFoodItem() {
        return foodItem;
    }

    public int getDivider() {
        return divider;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    /**
     * Consumes some fluid and gives the player the appropriate effect
     *
     * @return if one unit has been consumed
     */
    public boolean consume(class_1657 player, class_1937 world, @Nullable Consumer<class_1799> nbtApplier) {

        class_1799 foodStack = this.foodItem.method_7854();
        if (nbtApplier != null) nbtApplier.accept(foodStack);

        //food

        class_4174 foodProperties = PlatHelper.getFoodProperties(foodStack, player);
        //single items are handled by items themselves
        if (this.divider == 1) {
            this.foodItem.method_7861(foodStack.method_7972(), world, player);
            if (foodProperties != null) {
                player.method_5783(this.foodItem.method_21831(), 1, 1);
            }
            //player already plays sound
            return true;
        }
        if (foodProperties != null && player.method_7332(false)) {

            player.method_7344().method_7585(foodProperties.comp_2491() / this.divider, foodProperties.comp_2492() / (float) this.divider);
            player.method_5783(this.foodItem.method_21831(), 1, 1);
            return true;
        }
        return false;
    }

    public static FoodProvider create(class_1792 item, int divider) {
        return CUSTOM_PROVIDERS.getOrDefault(item, new FoodProvider(item, divider));
    }

    private static final FoodProvider XP = new FoodProvider(class_1802.field_8287, 1) {

        @Override
        public boolean consume(class_1657 player, class_1937 world, @Nullable Consumer<class_1799> nbtApplier) {
            player.method_7255(Utils.getXPinaBottle(1, world.field_9229));
            player.method_5783(class_3417.field_14627, 1, 1);
            return true;
        }
    };

    private static final FoodProvider MILK = new FoodProvider(class_1802.field_8103, 3) {

        @Override
        public boolean consume(class_1657 player, class_1937 world, @Nullable Consumer<class_1799> nbtApplier) {
            class_1799 stack = this.foodItem.method_7854();
            if (nbtApplier != null) nbtApplier.accept(stack);
            for (class_1293 effect : player.method_6088().values()) {
                if (ForgeHelper.isCurativeItem(stack, effect)) {
                    player.method_6016(effect.method_5579());
                    break;
                }
            }
            player.method_5783(this.foodItem.method_21831(), 1, 1);
            return true;
        }
    };

    private static final FoodProvider SUS_STEW = new FoodProvider(class_1802.field_8766, 2) {

        @Override
        public boolean consume(class_1657 player, class_1937 world, @Nullable Consumer<class_1799> nbtApplier) {
            class_1799 stack = this.foodItem.method_7854();
            if (nbtApplier != null) nbtApplier.accept(stack);
            class_4174 foodProperties = PlatHelper.getFoodProperties(stack, player);
            if (foodProperties != null && player.method_7332(false)) {
                class_9298 suspiciousStewEffects = stack.method_57825(class_9334.field_49652, class_9298.field_49362);

                for (class_9298.class_8751 entry : suspiciousStewEffects.comp_2416()) {
                    int j = entry.comp_1839() / this.divider;
                    player.method_6092(new class_1293(entry.comp_1838(), j));
                }

                player.method_7344().method_7585(foodProperties.comp_2491() / this.divider, foodProperties.comp_2492() / (float) this.divider);
                player.method_5783(this.foodItem.method_21831(), 1, 1);
                return true;
            }
            return false;
        }
    };

    public static final Map<class_1792, FoodProvider> CUSTOM_PROVIDERS = Map.of(
            class_1802.field_8162, EMPTY,
            class_1802.field_8766, SUS_STEW,
            class_1802.field_8103, MILK,
            class_1802.field_8287, XP
    );
}
