package net.mehvahdjukaar.moonlight.api.fluids.fabric;

import ;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.mehvahdjukaar.moonlight.api.misc.Triplet;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SoftFluidImpl {

    public static Pair<Integer, class_2561> getFluidSpecificAttributes(class_3611 fluid) {
        FluidVariant variant = FluidVariant.of(fluid);
        int l = FluidVariantAttributes.getLuminance(variant);
        class_2561 tr = FluidVariantAttributes.getName(variant);
        return Pair.of(l, tr);
    }

    @Nullable
    public static Triplet<class_2960, class_2960, Integer> getRenderingData(class_2960 useTexturesFrom) {
        var fluid = class_7923.field_41173.method_17966(useTexturesFrom);
        if (fluid.isPresent()) {
            var f = fluid.get();
            FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(f);
            if (handler != null) {
                try {
                    var textures = handler.getFluidSprites(null, null, f.method_15785());
                    int tint = handler.getFluidColor(null, null, f.method_15785());
                    return Triplet.of(textures[0].method_45851().method_45816(), textures[1].method_45851().method_45816(), tint);
                } catch (Exception e) {
                    throw new IllegalStateException("Fluid " + useTexturesFrom + " had invalid rendering data. How? FluidRenderHandler MUST have at lest 2 textures", e);
                }
            }
        }
        return null;
    }
}
