package net.mehvahdjukaar.moonlight.api.fluids.fabric;

import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.minecraft.class_6880;
import net.minecraft.class_9326;
import net.minecraft.class_9326.class_9327;
import net.minecraft.class_9331;

public class SoftFluidStackImpl extends SoftFluidStack {

    public SoftFluidStackImpl(class_6880<SoftFluid> fluid, int count, class_9326 tag) {
        super(fluid, count, tag);
    }

    public static SoftFluidStack of(class_6880<SoftFluid> fluid, int count, class_9326 components) {
        return new SoftFluidStackImpl(fluid, count, components);
    }

    public static FluidVariant toFabricFluid(SoftFluidStack softFluid) {
        var comps = softFluid.method_57353().method_57940();
        var patch = class_9326.method_57841();
        for (var t : softFluid.fluid().getPreservedComponents()) {
            setComp(t.comp_349(), comps, patch);
        }
        return FluidVariant.of(softFluid.fluid().getVanillaFluid().comp_349(), patch.method_57852());
    }

    private static <A> void setComp(class_9331<A> t, class_9326 comps, class_9326.class_9327 patch) {
        var val = comps.method_57845(t);
        if (val != null && val.isPresent()) {
            patch.method_57854(t, val.get());
        }
    }

    public static SoftFluidStack fromFabricFluid(FluidVariant variant, int bottlesAmount) {
        var comps = variant.getComponents();
        var patch = class_9326.method_57841();
        var softFluid = SoftFluidStack.fromFluid(variant.getFluid(), bottlesAmount);
        for (var t : softFluid.fluid().getPreservedComponents()) {
            setComp(t.comp_349(), comps, patch);
        }

        return SoftFluidStackImpl.of(softFluid.getHolder(), softFluid.getCount(), patch.method_57852());
    }

}
