package net.mehvahdjukaar.moonlight.api.item.additional_placements;

import net.minecraft.class_1269;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Nullable;

/**
 * Something called by mixin which should place or alter a block when clicked on
 * Extend this class if you intend on having a placeable block
 */
public class AdditionalItemPlacement{

    private final class_2248 placeable;

    public AdditionalItemPlacement(class_2248 placeable){
        this.placeable = placeable;
    }

    public static BlockPlacerItem getBlockPlacer(){
        return BlockPlacerItem.get();
    }

    @Nullable
    public class_2680 overrideGetPlacementState(class_1750 pContext) {
        return getBlockPlacer().mimicGetPlacementState(pContext, placeable);
    }

    public class_1269 overrideUseOn(class_1838 pContext, class_4174 foodProperties) {
        return getBlockPlacer().mimicUseOn(pContext, placeable, foodProperties);
    }

    public class_1269 overridePlace(class_1750 pContext) {
        return getBlockPlacer().mimicPlace(pContext, placeable, null);
    }

    @Nullable
    public class_1750 overrideUpdatePlacementContext(class_1750 context) {
        return null;
    }

    public class_2248 getPlacedBlock() {
        return placeable;
    }

    @Override
    public String toString() {
        return "AdditionalItemPlacement{" +
                "placeable=" + placeable +
                '}';
    }
}
