package net.mehvahdjukaar.moonlight.api.map.decoration;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1275;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3825;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

import java.util.Optional;

//Base type for simple data-driven type. Basically a simple version of CustomDecorationType that can be serialized
public final class MLJsonMapDecorationType extends MLMapDecorationType<MLMapDecoration, SimpleMapMarker> {

    private static final class_2960 FACTORY_ID = Moonlight.res("json_decoration_type");
    static final Codec<MLJsonMapDecorationType> CODEC;

    static {
        CODEC = RecordCodecBuilder.create(instance -> instance.group(
                //purposefully lenient
                class_3825.field_25012.lenientOptionalFieldOf("target_block").forGetter(MLJsonMapDecorationType::getTarget),
                class_8824.field_46598.optionalFieldOf("name").forGetter(MLJsonMapDecorationType::getDisplayName),
                Codec.FLOAT.optionalFieldOf("rotation", 0f).forGetter(MLJsonMapDecorationType::getRotation),
                ColorUtils.CODEC.optionalFieldOf("map_color", 0).forGetter(MLJsonMapDecorationType::getDefaultMapColor),
                //purposefully lenient for the client codec so we silently fail and dont send info we dont need as they rely on tags and we arent given registry ops there
                class_6895.method_40340(class_7924.field_41246).lenientOptionalFieldOf("target_structures").forGetter(
                        MLJsonMapDecorationType::getAssociatedStructure)
        ).apply(instance, MLJsonMapDecorationType::new));
    }

    //using this and not block predicate since it requires a worldLevelGen...
    private final Optional<class_3825> target;
    private final Optional<class_2561> name;
    private final Optional<class_6885<class_3195>> structures;
    private final int defaultMapColor;
    private final float defaultRotation;


    public MLJsonMapDecorationType(Optional<class_3825> target) {
        this(target, Optional.empty(), 0, 0);
    }

    public MLJsonMapDecorationType(Optional<class_3825> target, Optional<class_2561> name, float rotation, int mapColor) {
        this(target, name, rotation, mapColor, Optional.empty());
    }

    public MLJsonMapDecorationType(Optional<class_3825> target, Optional<class_2561> name, float rotation,
                                   int mapColor, Optional<class_6885<class_3195>> structure) {
        super(SimpleMapMarker.DIRECT_CODEC, MLMapDecoration.DIRECT_CODEC);
        this.target = target;
        this.name = name;
        this.defaultRotation = rotation;
        this.structures = structure;
        this.defaultMapColor = mapColor;
    }

    @Override
    public class_2960 getCustomFactoryID() {
        return FACTORY_ID;
    }

    public Optional<class_3825> getTarget() {
        return target;
    }

    public Optional<class_2561> getDisplayName() {
        return name;
    }

    public float getRotation() {
        return defaultRotation;
    }

    public Optional<class_6885<class_3195>> getAssociatedStructure() {
        return structures;
    }

    public int getDefaultMapColor() {
        return defaultMapColor;
    }

    @Override
    public boolean isFromWorld() {
        return target.isPresent();
    }

    @Nullable
    @Override
    public SimpleMapMarker createMarkerFromWorld(class_1922 reader, class_2338 pos) {
        if (this.target.isPresent()) {
            if (target.get().method_16768(reader.method_8320(pos), class_5819.method_43047())) {
                Optional<class_2561> name = this.getDisplayName();
                if (!name.isPresent()) {
                    class_2586 be = reader.method_8321(pos);
                    if (be instanceof class_1275 n) {
                        // auto names named stuff
                        name = Optional.ofNullable(n.method_5797());
                    }
                }
                return new SimpleMapMarker(
                        this.wrapAsHolder(),
                        pos, defaultRotation, name);
            }
        }
        return null;
    }

}
