package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.class_1268;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;

public interface SlotProvider {
    Iterator<Slot> getSlots(class_1661 inv);


    static SlotProvider hand(class_1268 hand) {
        if (hand == class_1268.field_5808) return MAIN_HAND;
        else return OFF_HAND;
    }

    static SlotProvider single(int slot) {
        return inv -> List.of(Slot.invSlot(inv, slot)).iterator();
    }

    SlotProvider ALL = inv -> IntStream.range(0, inv.field_7547.size())
            .mapToObj(i -> Slot.invSlot(inv, i)).iterator();

    SlotProvider OFF_HAND = inv -> IntStream.range(0, inv.field_7544.size())
            .mapToObj(i -> Slot.offHandSlot(inv, i)).iterator();

    SlotProvider MAIN_HAND = inv -> List.of(Slot.invSlot(inv, inv.field_7545)).iterator();

    interface Slot {
        class_1799 getStack();

        boolean add(class_1799 stack, class_1661 inv, class_1657 player);

        static Slot invSlot(class_1661 inv, int slot) {
            return new Slot() {
                @Override
                public class_1799 getStack() {
                    return inv.method_5438(slot);
                }

                @Override
                public boolean add(class_1799 toAdd, class_1661 inv, class_1657 player) {
                    class_1799 current = getStack();
                    //vanilla doesn't do this for some reason... calling add alone will just incrememnt the count of an existing item
                    if (!current.method_7960() && !inv.method_7393(current, toAdd)) return false;

                    //same as vanilla .add but no damageable and creative bs logic
                    if (toAdd.method_7960()) {
                        return false;
                    } else {
                        try {
                            int originalCount;
                            do {
                                originalCount = toAdd.method_7947();
                                toAdd.method_7939(inv.method_7385(slot, toAdd));
                            } while (!toAdd.method_7960() && toAdd.method_7947() < originalCount);

                            return toAdd.method_7947() < originalCount;
                        } catch (Throwable var6) {
                            class_128 crashReport = class_128.method_560(var6, "Adding item to inventory");
                            class_129 crashReportCategory = crashReport.method_562("Item being added");
                            crashReportCategory.method_578("Item ID", class_1792.method_7880(toAdd.method_7909()));
                            crashReportCategory.method_578("Item data", toAdd.method_7919());
                            crashReportCategory.method_577("Item name", () -> toAdd.method_7964().getString());
                            throw new class_148(crashReport);
                        }
                    }
                }
            };


        }

        static Slot offHandSlot(class_1661 inv, int offHandSlot) {
            return new Slot() {
                @Override
                public class_1799 getStack() {
                    return inv.field_7544.get(offHandSlot);
                }

                //copied from Inventory.addResource but for offhand
                @Override
                public boolean add(class_1799 stack, class_1661 inv, class_1657 player) {
                    if (stack.method_7960()) {
                        return false;
                    } else {
                        try {
                            int originalCount;
                            do {
                                originalCount = stack.method_7947();
                                addResourceOffHand(stack, inv);
                            } while (!stack.method_7960() && stack.method_7947() < originalCount);

                            if (stack.method_7947() == originalCount && player.method_31549().field_7477) {
                                stack.method_7939(0);
                                return true;
                            } else {
                                return stack.method_7947() < originalCount;
                            }
                        } catch (Throwable var6) {
                            class_128 crashReport = class_128.method_560(var6, "Adding item to inventory");
                            class_129 crashReportCategory = crashReport.method_562("Item being added");
                            crashReportCategory.method_578("Item ID", class_1792.method_7880(stack.method_7909()));
                            crashReportCategory.method_578("Item data", stack.method_7919());
                            crashReportCategory.method_577("Item name", () -> stack.method_7964().getString());
                            throw new class_148(crashReport);
                        }
                    }
                }

                private void addResourceOffHand(class_1799 toAdd, class_1661 inv) {
                    int stackCount;
                    class_2371<class_1799> offHand = inv.field_7544;
                    for (int offSlot = 0; offSlot < offHand.size(); offSlot++) {
                        stackCount = toAdd.method_7947();
                        class_1799 itemStack = offHand.get(offSlot);
                        if (itemStack.method_7960()) {
                            itemStack = toAdd.method_46651(0);
                            offHand.set(offSlot, itemStack);
                            return;
                        }

                        int possibleSpace = inv.method_58350(itemStack) - itemStack.method_7947();
                        int addedCount = Math.min(stackCount, possibleSpace);
                        if (addedCount != 0) {
                            stackCount -= addedCount;
                            itemStack.method_7933(addedCount);
                            itemStack.method_7912(5);

                            toAdd.method_7939(stackCount);
                        }
                    }
                }
            };
        }
    }

}

