package net.mehvahdjukaar.moonlight.api.misc;

import com.mojang.datafixers.util.Either;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;

public class TileOrEntityTarget {

    private final Either<class_2338, Integer> posOrEntityId;

    private TileOrEntityTarget(Either<class_2338, Integer> either) {
        this.posOrEntityId = either;
    }


    //bad code
    public static TileOrEntityTarget orThrow(Object object) {
        if (object instanceof class_2586 be) {
            return TileOrEntityTarget.of(be);
        } else if (object instanceof class_1297 entity) {
            return TileOrEntityTarget.of(entity);
        } else {
            throw new IllegalArgumentException("Object must be a BlockEntity or Entity");
        }
    }

    public static TileOrEntityTarget of(class_2586 be) {
        return new TileOrEntityTarget(Either.left(be.method_11016()));
    }

    public static TileOrEntityTarget of(class_1297 entity) {
        return new TileOrEntityTarget(Either.right(entity.method_5628()));
    }

    public void write(class_2540 buf) {
        buf.method_52964(posOrEntityId.left().isPresent());
        if (posOrEntityId.left().isPresent()) {
            buf.method_10807(posOrEntityId.left().get());
        } else {
            buf.method_10804(posOrEntityId.right().get());
        }
    }

    public static TileOrEntityTarget read(class_2540 buf) {
        if (buf.readBoolean()) {
            return new TileOrEntityTarget(Either.left(buf.method_10811()));
        } else {
            return new TileOrEntityTarget(Either.right(buf.method_10816()));
        }
    }

    @Nullable
    public Object getTarget(class_1937 level) {
        if (this.posOrEntityId.left().isPresent()) {
            class_2338 pos = this.posOrEntityId.left().get();
            var be = level.method_8321(pos);
            if (be != null) return be;
            return level.method_8320(pos);
        } else {
            return level.method_8469(this.posOrEntityId.right().get());
        }
    }

    public <T extends class_2586> T getBlockEntityOrThrow(class_1937 level, class_2591<T> type) {
        if (this.posOrEntityId.left().isPresent()) {
            var be = type.method_24182(level, this.posOrEntityId.left().get());
            if (be != null) {
                return be;
            }
        }
        throw new IllegalStateException("No BlockEntity found at " + this.posOrEntityId.left().orElse(null));
    }

    public <T extends class_1297> T getEntityOrThrow(class_1937 level, class_1299<T> type) {
        if (this.posOrEntityId.right().isPresent()) {
            var entity = level.method_8469(this.posOrEntityId.right().get());
            if (entity != null && entity.method_5864() == type) {
                return (T) (entity);
            }
        }
        throw new IllegalStateException("No Entity found with ID " + this.posOrEntityId.right().orElse(null));
    }

    @Nullable
    public <T> T map(class_1937 level, Function<class_2586, T> a, Function<class_1297, T> b) {
        if (this.posOrEntityId.left().isPresent()) {
            var be = level.method_8321(this.posOrEntityId.left().get());
            if (be != null) return a.apply(be);
        } else {
            var entity = level.method_8469(this.posOrEntityId.right().get());
            if (entity != null) return b.apply(entity);
        }
        return null;
    }


    @Nullable
    public class_2338 getPos() {
        return this.posOrEntityId.left().orElse(null);
    }

    @Nullable
    public Integer getEntityId() {
        return this.posOrEntityId.right().orElse(null);
    }

    @Override
    public String toString() {
        return "TileOrEntityTarget{" +
                "posOrEntityId=" + posOrEntityId +
                '}';
    }
}
