package net.mehvahdjukaar.moonlight.api.misc.fake_level;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.VisibleForTesting;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiFunction;

public class FakeLevelManager {

    protected static final Map<String, class_1937> INSTANCES = new Object2ObjectArrayMap<>();

    @ApiStatus.Internal
    @VisibleForTesting
    public static void invalidateAll() {
        new ArrayList<>(INSTANCES.values()).forEach(FakeLevelManager::invalidate);
    }

    // Manually invalidate one
    public static boolean invalidate(class_1937 level) {
        boolean removed = INSTANCES.entrySet().removeIf(e -> e.getValue() == level);

        if (level != null) PlatHelper.invokeLevelUnload(level);
        try {
            if (level instanceof FakeServerLevel) {
                level.close();
            }
        } catch (Exception e) {
            if (PlatHelper.isDev()) {
                throw new RuntimeException(e);
            } else {
                Moonlight.LOGGER.error("An error occurred while closing fake level", e);
            }
        }
        return removed;
    }

    @Deprecated(forRemoval = true)
    public static void invalidate(String name) {
    }

    public static FakeLevel getDefaultClient(class_1937 original) {
        return getClient("dummy_world", original, FakeLevel::new);
    }

    public static <T extends FakeLevel> T getClient(String id, class_1937 original, BiFunction<String, class_5455, FakeLevel> constructor) {
        id = "client_" + id;
        String finalId = id;
        return (T) INSTANCES.computeIfAbsent(id, k -> constructor.apply(finalId, original.method_30349()));
    }


    public static FakeServerLevel getDefaultServer(class_3218 original) {
        return getServer("dummy_world", original, FakeServerLevel::new);
    }

    public static <T extends FakeServerLevel> T getServer(String id, class_3218 original, BiFunction<String, class_3218, FakeServerLevel> constructor) {
        id = "server_" + id;
        String finalId = id;
        return (T) INSTANCES.computeIfAbsent(id, k -> constructor.apply(finalId, original));
    }

    public static class_1937 get(String id, class_1937 original,
                            BiFunction<String, class_5455, FakeLevel> clientConstr,
                            BiFunction<String, class_3218, FakeServerLevel> serverConstr) {
        if (original instanceof class_3218 sl) {
            return getServer(id, sl, serverConstr);
        } else {
            return getClient(id, original, clientConstr);
        }
    }

    public static class_1937 getDefault(class_1937 original) {
        if (original instanceof class_3218 sl) {
            return getDefaultServer(sl);
        } else {
            return getDefaultClient(original);
        }
    }

    public interface ILevelLike {
        class_1937 cast();
    }
}
