/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.SimpleTagBuilder;
import net.mehvahdjukaar.moonlight.api.resources.StaticResource;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.resources.pack.InMemoryPackResources;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.integration.ModernFixCompat;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Deprecated(forRemoval=true)
public abstract class DynamicResourcePack
extends InMemoryPackResources {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Pack.Position position;
    public final String mainNamespace;
    public final ResourceLocation resourcePackName;
    private boolean needsClearingNonStatic = false;
    boolean addToStatic = false;
    private static final boolean MODERN_FIX = CompatHandler.MODERNFIX && ModernFixCompat.areLazyResourcesOn();

    protected DynamicResourcePack(ResourceLocation name, PackType type) {
        this(name, type, Pack.Position.TOP, false);
    }

    protected DynamicResourcePack(ResourceLocation name, PackType type, Pack.Position position, boolean fixed, boolean hidden) {
        this(name, type, position, hidden);
    }

    protected DynamicResourcePack(ResourceLocation name, PackType type, Pack.Position position, boolean hidden) {
        super(DynamicResourcePack.makeInfo(name), type, hidden);
        this.position = position;
        this.mainNamespace = name.getNamespace();
        this.resourcePackName = name;
    }

    private static PackLocationInfo makeInfo(ResourceLocation name) {
        return new PackLocationInfo(name.toString(), (Component)Component.translatable((String)LangBuilder.getReadableName(name.toString())), PackSource.BUILT_IN, Optional.empty());
    }

    public void markNotClearable(ResourceLocation texturePath) {
    }

    public void unMarkNotClearable(ResourceLocation staticResources) {
    }

    public ResourceLocation id() {
        return this.resourcePackName;
    }

    public String toString() {
        return this.packId();
    }

    public Component getTitle() {
        return this.location().title();
    }

    public void registerPack() {
        PackType packType = this.getPackType();
        final DynamicResourcePack p = this;
        if (packType == PackType.CLIENT_RESOURCES && MoonlightClient.maybeMergeLegacyPack(this)) {
            return;
        }
        RegHelper.registerResourcePack(packType, () -> Pack.readMetaAndCreate((PackLocationInfo)this.location(), (Pack.ResourcesSupplier)new Pack.ResourcesSupplier(){

            public PackResources openPrimary(PackLocationInfo location) {
                return p;
            }

            public PackResources openFull(PackLocationInfo location, Pack.Metadata metadata) {
                return p;
            }
        }, (PackType)packType, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false)));
    }

    public FileNotFoundException makeFileNotFoundException(String path) {
        return new FileNotFoundException(String.format("'%s' in ResourcePack '%s'", path, this.resourcePackName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated(forRemoval=true)
    public void removeResource(ResourceLocation res) {
        DynamicResourcePack dynamicResourcePack = this;
        synchronized (dynamicResourcePack) {
            this.searchTrie.remove(res);
            this.resources.remove(res);
        }
    }

    public final void clearNonStatic() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllContent() {
        DynamicResourcePack dynamicResourcePack = this;
        synchronized (dynamicResourcePack) {
            this.searchTrie.clear();
            this.resources.clear();
            this.needsClearingNonStatic = true;
        }
    }

    private boolean modernFixHack(String s) {
        return s.startsWith("model") || s.startsWith("blockstate");
    }

    @Deprecated(forRemoval=true)
    public void addResource(StaticResource resource) {
        this.addResource(resource.location, resource.data);
    }

    @Deprecated(forRemoval=true)
    private void addJson(ResourceLocation path, JsonElement json) {
        try {
            this.addResource(path, RPUtils.serializeJson(json).getBytes());
        }
        catch (IOException e) {
            LOGGER.error("Failed to write JSON {} to resource pack {}.", (Object)path, (Object)this.resourcePackName, (Object)e);
        }
    }

    @Deprecated(forRemoval=true)
    public void addJson(ResourceLocation location, JsonElement json, ResType resType) {
        this.addJson(resType.getPath(location), json);
    }

    @Deprecated(forRemoval=true)
    public void addBytes(ResourceLocation location, byte[] bytes, ResType resType) {
        this.addResource(resType.getPath(location), bytes);
    }

    @Deprecated(forRemoval=true)
    public void addTag(SimpleTagBuilder builder, ResourceKey<?> type) {
        String tagPath;
        ResourceLocation tagId = builder.getId();
        ResourceLocation loc = ResType.TAGS.getPath(tagId.withPath((tagPath = type.location().getPath()) + "/" + tagId.getPath()));
        if (this.resources.containsKey(loc)) {
            byte[] r = (byte[])this.resources.get(loc);
            try (ByteArrayInputStream stream = new ByteArrayInputStream(r);){
                JsonObject oldTag = RPUtils.deserializeJson(stream);
                builder.addFromJson(oldTag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JsonElement json = builder.serializeToJson();
        this.addJson(loc, json, ResType.GENERIC);
    }

    @Deprecated(forRemoval=true)
    public void addSimpleBlockLootTable(Block block) {
        this.addLootTable(block, DynamicResourcePack.createSingleItemTable((ItemLike)block).setParamSet(LootContextParamSets.BLOCK));
    }

    @Deprecated(forRemoval=true)
    public void addLootTable(Block block, LootTable.Builder table) {
        this.addLootTable(block.getLootTable().location(), table.build());
    }

    @Deprecated(forRemoval=true)
    public void addLootTable(ResourceLocation id, LootTable table) {
        this.addJson(id, (JsonElement)LootDataType.TABLE.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)table).getOrThrow(), ResType.LOOT_TABLES);
    }

    protected static LootTable.Builder createSingleItemTable(ItemLike itemLike) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike)).unwrap());
    }

    @Deprecated(forRemoval=true)
    public void addRecipe(RecipeHolder<?> holder) {
        this.addRecipe(holder.value(), holder.id());
    }

    public void addRecipe(Recipe<?> recipe, ResourceLocation id) {
        this.addRecipeNoAdvancement(recipe, id);
    }

    @Deprecated(forRemoval=true)
    public void addRecipeNoAdvancement(Recipe<?> recipe, ResourceLocation id) {
        this.addJson(id, RPUtils.writeRecipe(recipe), ResType.RECIPES);
    }

    @Deprecated(forRemoval=true)
    public void addAndCloseTexture(ResourceLocation path, TextureImage image) {
        this.addAndCloseTexture(path, image, true);
    }

    @Deprecated(forRemoval=true)
    public void addAndCloseTexture(ResourceLocation path, TextureImage image, boolean isOnAtlas) {
        try (TextureImage textureImage = image;){
            this.addBytes(path, image.getImage().asByteArray(), ResType.TEXTURES);
            if (!isOnAtlas) {
                this.markNotClearable(ResType.TEXTURES.getPath(path));
            }
            if (image.getMcMeta() != null) {
                this.addJson(path, (JsonElement)image.getMcMeta().toJson(), ResType.MCMETA);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to add image {} to resource pack {}.", (Object)path, (Object)this, (Object)e);
        }
    }

    @Deprecated(forRemoval=true)
    public void addBlockModel(ResourceLocation modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCK_MODELS);
    }

    @Deprecated(forRemoval=true)
    public void addItemModel(ResourceLocation modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.ITEM_MODELS);
    }

    @Deprecated(forRemoval=true)
    public void addBlockState(ResourceLocation modelLocation, JsonElement model) {
        this.addJson(modelLocation, model, ResType.BLOCKSTATES);
    }

    @Deprecated(forRemoval=true)
    public void addLang(ResourceLocation langName, JsonElement language) {
        this.addJson(langName, language, ResType.LANG);
    }

    @Deprecated(forRemoval=true)
    public void addLang(ResourceLocation langName, LangBuilder builder) {
        this.addJson(langName, builder.build(), ResType.LANG);
    }

    @Deprecated(forRemoval=true)
    public void setGenerateDebugResources(boolean generateDebugResources) {
    }

    @Deprecated(forRemoval=true)
    public void setClearOnReload(boolean canBeCleared) {
    }
}

