/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.mehvahdjukaar.moonlight.api.misc.ResourceLocationSearchTrie;
import net.mehvahdjukaar.moonlight.api.resources.RPUtils;
import net.mehvahdjukaar.moonlight.api.resources.pack.IDebugDumpable;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3255;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_7367;
import net.minecraft.class_9224;
import org.jetbrains.annotations.Nullable;

public class InMemoryPackResources
extends class_3255
implements IEditablePackResources,
IDebugDumpable {
    protected final boolean hidden;
    protected final class_3264 packType;
    protected final class_3272 metadata;
    protected final Set<String> namespaces = new HashSet<String>();
    protected final Map<class_2960, byte[]> resources = new ConcurrentHashMap<class_2960, byte[]>();
    protected final Map<String, byte[]> rootResources = new ConcurrentHashMap<String, byte[]>();
    protected final ResourceLocationSearchTrie searchTrie = new ResourceLocationSearchTrie();

    protected InMemoryPackResources(class_9224 info, class_3264 type) {
        this(info, type, false);
    }

    protected InMemoryPackResources(class_9224 info, class_3264 type, boolean hidden) {
        super(info);
        this.packType = type;
        this.hidden = hidden;
        this.metadata = new class_3272((class_2561)class_2561.method_43471((String)"message.moonlight.runtime"), class_155.method_16673().method_48017(this.packType), Optional.empty());
    }

    public Set<String> method_14406(class_3264 packType) {
        if (packType != this.packType) {
            return Set.of();
        }
        return this.namespaces;
    }

    public <T> T method_14407(class_3270<T> serializer) {
        try {
            return (T)(serializer == class_3272.field_14202 ? this.metadata : null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        String fileName = String.join((CharSequence)"/", strings);
        byte[] resource = this.rootResources.get(fileName);
        return resource == null ? null : () -> new ByteArrayInputStream(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_14408(class_3264 packType, String namespace, String id, class_3262.class_7664 output) {
        if (packType == this.packType) {
            InMemoryPackResources inMemoryPackResources = this;
            synchronized (inMemoryPackResources) {
                this.searchTrie.search(namespace + "/" + id).forEach(r -> {
                    byte[] buf = this.resources.get(r);
                    output.accept(r, () -> {
                        if (buf == null) {
                            throw new IllegalStateException("Somehow search tree returned a resource not in resources " + String.valueOf(r));
                        }
                        return new ByteArrayInputStream(buf);
                    });
                });
            }
        }
    }

    public class_7367<InputStream> method_14405(class_3264 type, class_2960 id) {
        byte[] res = this.resources.get(id);
        if (res != null) {
            return () -> {
                if (type != this.packType) {
                    throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.method_14409()));
                }
                return new ByteArrayInputStream(res);
            };
        }
        return null;
    }

    public void close() {
    }

    @Override
    public void addNamespaces(String ... namespaces) {
        this.namespaces.addAll(Arrays.asList(namespaces));
    }

    @Override
    public void addRootResource(String name, byte[] resource) {
        this.rootResources.put(name, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResource(class_2960 id, byte[] bytes) {
        InMemoryPackResources inMemoryPackResources = this;
        synchronized (inMemoryPackResources) {
            this.namespaces.add(id.method_12836());
            this.resources.put(id, bytes);
            this.searchTrie.insert(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResource(class_2960 id) {
        InMemoryPackResources inMemoryPackResources = this;
        synchronized (inMemoryPackResources) {
            this.resources.remove(id);
            this.searchTrie.remove(id);
        }
    }

    @Override
    public void removeRootResource(String name) {
        this.rootResources.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearAllResources() {
        InMemoryPackResources inMemoryPackResources = this;
        synchronized (inMemoryPackResources) {
            this.resources.clear();
            this.rootResources.clear();
            this.searchTrie.clear();
        }
        return true;
    }

    @Override
    public class_3264 getPackType() {
        return this.packType;
    }

    @Override
    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    @Override
    public void dumpToDisk(Path path) {
        this.resources.forEach((k, v) -> {
            try {
                Path p = RPUtils.getResourcePath(path, k, this.packType);
                Files.createDirectories(p.getParent(), new FileAttribute[0]);
                Files.write(p, v, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }
}

